/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

abstract class LUDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements LU<N> {
    private Pivot myPivot;

    protected LUDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean computeWithoutPivoting(ElementsSupplier<N> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public boolean decompose(ElementsSupplier<N> aStore) {
        return this.compute(aStore, false);
    }

    @Override
    public boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        if (this.myPivot.signum() == -1) {
            return ((Scalar)tmpAggrFunc.toScalar().negate()).getNumber();
        }
        return tmpAggrFunc.getNumber();
    }

    @Override
    public MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        if (this.myPivot.isModified()) {
            preallocated.fillAll(this.scalar().zero().getNumber());
            int[] tmpPivotOrder = this.myPivot.getOrder();
            int tmpRowDim = this.getRowDim();
            for (int i = 0; i < tmpRowDim; ++i) {
                preallocated.set((long)i, (long)tmpPivotOrder[i], PrimitiveMath.ONE);
            }
        }
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, true, false, !this.myPivot.isModified());
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    @Override
    public MatrixStore<N> getL() {
        return this.getInPlace().builder().triangular(false, true).build();
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public int getRank() {
        int retVal = 0;
        DecompositionStore tmpInPlace = this.getInPlace();
        AggregatorFunction tmpLargest = this.aggregator().largest();
        tmpInPlace.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        int tmpMinDim = this.getMinDim();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpInPlace.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getU() {
        return this.getInPlace().builder().triangular(true, false).build();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.isSquareAndNotSingular();
    }

    @Override
    public final boolean isSquareAndNotSingular() {
        boolean retVal = this.getRowDim() == this.getColDim();
        DecompositionStore tmpStore = this.getInPlace();
        int tmpMinDim = (int)Math.min(tmpStore.countRows(), tmpStore.countColumns());
        for (int ij = 0; retVal && ij < tmpMinDim; retVal &= !tmpStore.isZero(ij, ij), ++ij) {
        }
        return retVal;
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myPivot = null;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.solve(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        preallocated.fillMatching((Access1D<?>)rhs.get().builder().row(this.myPivot.getOrder()).get());
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, true, false, false);
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    private final boolean compute(ElementsSupplier<N> aStore, boolean assumeNoPivotingRequired) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(aStore);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpMinDim = this.getMinDim();
        this.myPivot = new Pivot(tmpRowDim);
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            int tmpPivotRow;
            if (!assumeNoPivotingRequired && (tmpPivotRow = tmpInPlace.indexOfLargestInColumn(ij, ij)) != ij) {
                tmpInPlace.exchangeRows(tmpPivotRow, ij);
                this.myPivot.change(tmpPivotRow, ij);
            }
            if (tmpInPlace.doubleValue(ij, ij) != PrimitiveMath.ZERO) {
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyLU(ij, tmpMultipliers);
                continue;
            }
            tmpInPlace.set((long)ij, (long)ij, PrimitiveMath.ZERO);
        }
        return this.computed(true);
    }

    int[] getReducedPivots() {
        int[] retVal = new int[this.getRank()];
        int[] tmpFullPivots = this.getPivotOrder();
        DecompositionStore tmpInPlace = this.getInPlace();
        int tmpRedInd = 0;
        for (int ij = 0; ij < tmpFullPivots.length; ++ij) {
            if (tmpInPlace.isZero(ij, ij)) continue;
            retVal[tmpRedInd++] = tmpFullPivots[ij];
        }
        return retVal;
    }

    static final class Primitive
    extends LUDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends LUDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }
    }

    static final class Big
    extends LUDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

