/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class QRDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements QR<N> {
    private boolean myFullSize = false;

    protected QRDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(ElementsSupplier<N> matrix) {
        this.reset();
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        Householder tmpHouseholder = this.makeHouseholder(tmpRowDim);
        int tmpLimit = Math.min(tmpRowDim, tmpColDim);
        for (int ij = 0; ij < tmpLimit; ++ij) {
            if (ij + 1 >= tmpRowDim || !tmpStore.generateApplyAndCopyHouseholderColumn(ij, ij, tmpHouseholder)) continue;
            tmpStore.transformLeft(tmpHouseholder, ij + 1);
        }
        return this.computed(true);
    }

    @Override
    public boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        return tmpAggrFunc.getNumber();
    }

    @Override
    public MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        return this.solve(this.makeIdentity(this.getRowDim()), preallocated);
    }

    @Override
    public MatrixStore<N> getQ() {
        DecompositionStore retVal = this.makeEye(this.getRowDim(), this.myFullSize ? this.getRowDim() : this.getMinDim());
        DecompositionStore.HouseholderReference tmpReference = new DecompositionStore.HouseholderReference(this.getInPlace(), true);
        for (int j = this.getMinDim() - 1; j >= 0; --j) {
            tmpReference.row = j;
            tmpReference.col = j;
            if (tmpReference.isZero()) continue;
            retVal.transformLeft(tmpReference, j);
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getR() {
        MatrixStore retVal = this.getInPlace().builder().triangular(true, false).build();
        int tmpPadding = this.getRowDim() - this.getColDim();
        if (this.myFullSize && tmpPadding < 0) {
            retVal = retVal.builder().below(tmpPadding).build();
        }
        return retVal;
    }

    @Override
    public int getRank() {
        int retVal = 0;
        DecompositionStore tmpInPlace = this.getInPlace();
        AggregatorFunction tmpLargest = this.aggregator().largest();
        tmpInPlace.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        int tmpMinDim = this.getMinDim();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpInPlace.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isFullColumnRank() {
        return this.getRank() == this.getMinDim();
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.isFullColumnRank();
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void setFullSize(boolean fullSize) {
        this.myFullSize = fullSize;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.solve(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore tmpStore = this.getInPlace();
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        DecompositionStore.HouseholderReference tmpReference = new DecompositionStore.HouseholderReference(tmpStore, true);
        int tmpLimit = this.getMinDim();
        for (int j = 0; j < tmpLimit; ++j) {
            tmpReference.row = j;
            tmpReference.col = j;
            if (tmpReference.isZero()) continue;
            preallocated.transformLeft(tmpReference, 0);
        }
        preallocated.substituteBackwards(tmpStore, false, false, false);
        if (tmpColDim < tmpRowDim) {
            return preallocated.builder().rows(0, tmpColDim).build();
        }
        if (tmpColDim > tmpRowDim) {
            return preallocated.builder().below(tmpColDim - tmpRowDim).build();
        }
        return preallocated;
    }

    protected DecompositionStore<N> getL() {
        int tmpRowDim = this.getColDim();
        int tmpColDim = this.getMinDim();
        DecompositionStore retVal = this.makeZero(tmpRowDim, tmpColDim);
        DecompositionStore tmpStore = this.getInPlace();
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = j; i < tmpRowDim; ++i) {
                retVal.set((long)i, (long)j, (Number)tmpStore.get(j, i));
            }
        }
        return retVal;
    }

    static final class Primitive
    extends QRDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends QRDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }
    }

    static final class Big
    extends QRDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

