/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.Tridiagonal;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.type.context.NumberContext;

class TridiagonalAltDecomp
extends InPlaceDecomposition<Double>
implements Tridiagonal<Double> {
    BasicArray<Double> myMain;
    BasicArray<Double> myOff;

    TridiagonalAltDecomp() {
        super(PrimitiveDenseStore.FACTORY);
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        this.setInPlace(matrix);
        this.myMain = PrimitiveArray.make(this.getMinDim());
        this.myOff = PrimitiveArray.make(this.getMinDim());
        this.getInPlace().tred2(this.myMain, this.myOff, true);
        return true;
    }

    @Override
    public boolean equals(MatrixStore<Double> other, NumberContext context) {
        return MatrixUtils.equals(other, this, context);
    }

    @Override
    public MatrixStore<Double> getD() {
        Array1D<Double> tmpMain = Array1D.PRIMITIVE.wrap(this.myMain);
        List tmpOff = Array1D.PRIMITIVE.wrap(this.myOff).subList(1, (int)this.myOff.count());
        DiagonalAccess<Double> tmpAccess = new DiagonalAccess<Double>(tmpMain, (Array1D<Double>)tmpOff, (Array1D<Double>)tmpOff, PrimitiveMath.ZERO);
        return this.wrap(tmpAccess).get();
    }

    @Override
    public MatrixStore<Double> getQ() {
        return this.getInPlace();
    }

    public boolean isFullSize() {
        return true;
    }

    public boolean isSolvable() {
        return false;
    }

    public MatrixStore<Double> solve(Access2D<Double> rhs, DecompositionStore<Double> preallocated) {
        throw new UnsupportedOperationException();
    }
}

