/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.AbstractStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

abstract class LogicalStore<N extends Number>
extends AbstractStore<N> {
    private MatrixStore<N> myBase;

    private LogicalStore(int aRowDim, int aColDim) {
        this(null, aRowDim, aColDim);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected LogicalStore(MatrixStore<N> base, int rowsCount, int columnsCount) {
        super(rowsCount, columnsCount);
        this.myBase = base;
        if (this.myBase == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot have a null 'base'!");
        }
    }

    @Override
    public final PhysicalStore.Factory<N, ?> factory() {
        return this.myBase.factory();
    }

    protected final MatrixStore<N> getBase() {
        return this.myBase;
    }
}

