/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.DelegatingStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.Scalar;

final class SuperimposedStore<N extends Number>
extends DelegatingStore<N> {
    private final int myColFirst;
    private final int myColLimit;
    private final MatrixStore<N> myDiff;
    private final int myRowFirst;
    private final int myRowLimit;

    private SuperimposedStore(int rowsCount, int columnsCount, MatrixStore<N> base) {
        this(base, 0, 0, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    SuperimposedStore(MatrixStore<N> base, int row, int column, MatrixStore<N> diff) {
        super((int)base.countRows(), (int)base.countColumns(), base);
        this.myRowFirst = row;
        this.myColFirst = column;
        int tmpDiffRowDim = (int)diff.countRows();
        int tmpDiffColDim = (int)diff.countColumns();
        this.myRowLimit = row + tmpDiffRowDim;
        this.myColLimit = column + tmpDiffColDim;
        this.myDiff = diff;
    }

    SuperimposedStore(MatrixStore<N> base, MatrixStore<N> diff) {
        this(base, 0, 0, diff);
    }

    @Override
    public double doubleValue(long row, long column) {
        double retVal = this.getBase().doubleValue(row, column);
        if (this.isCovered((int)row, (int)column)) {
            retVal += this.myDiff.doubleValue(row - (long)this.myRowFirst, column - (long)this.myColFirst);
        }
        return retVal;
    }

    @Override
    public N get(long row, long column) {
        Object retVal = this.getBase().get(row, column);
        if (this.isCovered((int)row, (int)column)) {
            retVal = ((Scalar)this.myDiff.toScalar((int)row - this.myRowFirst, (int)column - this.myColFirst).add(retVal)).getNumber();
        }
        return retVal;
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        Scalar retVal = this.getBase().toScalar(row, column);
        if (this.isCovered((int)row, (int)column)) {
            retVal = (Scalar)retVal.add(this.myDiff.get(row - (long)this.myRowFirst, column - (long)this.myColFirst));
        }
        return retVal;
    }

    private final boolean isCovered(int row, int column) {
        return this.myRowFirst <= row && this.myColFirst <= column && row < this.myRowLimit && column < this.myColLimit;
    }

    @Override
    protected void supplyNonZerosTo(ElementsConsumer<N> consumer) {
        consumer.fillMatching(this.getBase());
        consumer.regionByLimits(this.myRowLimit, this.myColLimit).regionByOffsets(this.myRowFirst, this.myColFirst).modifyMatching(this.factory().function().add(), this.myDiff);
    }
}

