/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.store.operation.SubtractScaledVector;
import org.ojalgo.scalar.ComplexNumber;

public final class ApplyCholesky
extends MatrixOperation {
    public static final ApplyCholesky SETUP = new ApplyCholesky();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            SubtractScaledVector.invoke(data, j * structure, multipliers, 0, multipliers[j], j, structure);
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, ComplexNumber[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            SubtractScaledVector.invoke(data, j * structure, multipliers, 0, multipliers[j].conjugate(), j, structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            SubtractScaledVector.invoke(data, j * structure, multipliers, 0, multipliers[j], j, structure);
        }
    }

    private ApplyCholesky() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

