/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;

public abstract class DotProduct
extends MatrixOperation {
    public static BigDecimal invoke(BigDecimal[] array1, int offset1, BigDecimal[] array2, int offset2, int first, int limit) {
        BigDecimal retVal = BigMath.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add(array1[offset1 + i].multiply(array2[offset2 + i]));
        }
        return retVal;
    }

    public static ComplexNumber invoke(ComplexNumber[] array1, int offset1, ComplexNumber[] array2, int offset2, int first, int limit) {
        ComplexNumber retVal = ComplexNumber.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add(array1[offset1 + i].multiply(array2[offset2 + i]));
        }
        return retVal;
    }

    public static double invoke(double[] array1, int offset1, double[] array2, int offset2, int first, int limit) {
        double retVal = PrimitiveMath.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal += array1[offset1 + i] * array2[offset2 + i];
        }
        return retVal;
    }

    public static RationalNumber invoke(RationalNumber[] array1, int offset1, RationalNumber[] array2, int offset2, int limit, int first) {
        RationalNumber retVal = RationalNumber.ZERO;
        for (int i = first; i < limit; ++i) {
            retVal = retVal.add(array1[offset1 + i].multiply(array2[offset2 + i]));
        }
        return retVal;
    }

    private DotProduct() {
    }
}

