/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class HermitianRank2Update
extends MatrixOperation {
    public static final HermitianRank2Update SETUP = new HermitianRank2Update();
    public static int THRESHOLD = 64;

    public static void invoke(BigDecimal[] aData, int aFirstCol, int aColLimit, BigDecimal[] aVector1, BigDecimal[] aVector2) {
        int tmpLength = aVector1.length;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            BigDecimal tmpVal1j = aVector1[j];
            BigDecimal tmpVal2j = aVector2[j];
            int tmpIndex = j + j * tmpLength;
            for (int i = j; i < tmpLength; ++i) {
                aData[tmpIndex] = aData[tmpIndex].subtract(aVector2[i].multiply(tmpVal1j).add(aVector1[i].multiply(tmpVal2j)));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] aData, int aFirstCol, int aColLimit, ComplexNumber[] aVector1, ComplexNumber[] aVector2) {
        int tmpLength = aVector1.length;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            ComplexNumber tmpVal1j = aVector1[j].conjugate();
            ComplexNumber tmpVal2j = aVector2[j].conjugate();
            int tmpIndex = j + j * tmpLength;
            for (int i = j; i < tmpLength; ++i) {
                aData[tmpIndex] = aData[tmpIndex].subtract(aVector2[i].multiply(tmpVal1j).add(aVector1[i].multiply(tmpVal2j)));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] aData, int aFirstCol, int aColLimit, double[] aVector1, double[] aVector2) {
        int tmpLength = aVector1.length;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            double tmpVal1j = aVector1[j];
            double tmpVal2j = aVector2[j];
            int tmpIndex = j + j * tmpLength;
            for (int i = j; i < tmpLength; ++i) {
                int n = tmpIndex++;
                aData[n] = aData[n] - (aVector2[i] * tmpVal1j + aVector1[i] * tmpVal2j);
            }
        }
    }

    private HermitianRank2Update() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

