/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class MultiplyHermitianAndVector
extends MatrixOperation {
    public static final MultiplyHermitianAndVector SETUP = new MultiplyHermitianAndVector();
    public static int THRESHOLD = 64;

    public static void invoke(BigDecimal[] productMtrx, int aFirst, int aLimit, BigDecimal[] aSymmetric, BigDecimal[] aVector, int aFirstNonZero) {
        int tmpRowDim = aVector.length;
        for (int i = aFirst; i < aLimit; ++i) {
            int c;
            BigDecimal tmpVal = BigMath.ZERO;
            for (c = aFirstNonZero; c < i; ++c) {
                tmpVal = tmpVal.add(aSymmetric[i + c * tmpRowDim].multiply(aVector[c]));
            }
            for (c = i; c < tmpRowDim; ++c) {
                tmpVal = tmpVal.add(aSymmetric[c + i * tmpRowDim].multiply(aVector[c]));
            }
            productMtrx[i] = tmpVal;
        }
    }

    public static void invoke(ComplexNumber[] productMtrx, int aFirst, int aLimit, ComplexNumber[] aSymmetric, ComplexNumber[] aVector, int aFirstNonZero) {
        int tmpRowDim = aVector.length;
        for (int i = aFirst; i < aLimit; ++i) {
            int c;
            ComplexNumber tmpVal = ComplexNumber.ZERO;
            for (c = aFirstNonZero; c < i; ++c) {
                tmpVal = tmpVal.add(aSymmetric[i + c * tmpRowDim].multiply(aVector[c]));
            }
            for (c = i; c < tmpRowDim; ++c) {
                tmpVal = tmpVal.add(aSymmetric[c + i * tmpRowDim].conjugate().multiply(aVector[c]));
            }
            productMtrx[i] = tmpVal;
        }
    }

    public static void invoke(double[] productMtrx, int aFirst, int aLimit, double[] aSymmetric, double[] aVector, int aFirstNonZero) {
        int tmpRowDim = aVector.length;
        for (int i = aFirst; i < aLimit; ++i) {
            int c;
            double tmpVal = PrimitiveMath.ZERO;
            for (c = aFirstNonZero; c < i; ++c) {
                tmpVal += aSymmetric[i + c * tmpRowDim] * aVector[c];
            }
            for (c = i; c < tmpRowDim; ++c) {
                tmpVal += aSymmetric[c + i * tmpRowDim] * aVector[c];
            }
            productMtrx[i] = tmpVal;
        }
    }

    private MultiplyHermitianAndVector() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

