/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.IntIndex;
import org.ojalgo.access.IntRowColumn;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.optimisation.AbstractModel;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedConvexIntegration;
import org.ojalgo.optimisation.ExpressionsBasedIntegerIntegration;
import org.ojalgo.optimisation.ExpressionsBasedLinearIntegration;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Presolvers;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.context.NumberContext;

public final class ExpressionsBasedModel
extends AbstractModel<GenericSolver> {
    private static final String NEW_LINE = "\n";
    private static final String OBJ_FUNC_AS_CONSTR_KEY = UUID.randomUUID().toString();
    private static final String OBJECTIVE = "Generated/Aggregated Objective";
    private static final String START_END = "############################################\n";
    static final Comparator<Expression> CE = new Comparator<Expression>(){

        @Override
        public int compare(Expression o1, Expression o2) {
            return Integer.compare(o2.countLinearFactors(), o1.countLinearFactors());
        }
    };
    static final List<Integration<?>> INTEGRATIONS = new ArrayList();
    static final TreeSet<Presolver> PRESOLVERS = new TreeSet();
    private final HashMap<String, Expression> myExpressions = new HashMap();
    private final HashSet<IntIndex> myFixedVariables = new HashSet();
    private transient int[] myFreeIndices = null;
    private final List<Variable> myFreeVariables = new ArrayList<Variable>();
    private transient int[] myIntegerIndices = null;
    private final List<Variable> myIntegerVariables = new ArrayList<Variable>();
    private transient int[] myNegativeIndices = null;
    private final List<Variable> myNegativeVariables = new ArrayList<Variable>();
    private transient int[] myPositiveIndices = null;
    private final List<Variable> myPositiveVariables = new ArrayList<Variable>();
    private final ArrayList<Variable> myVariables = new ArrayList();
    private final boolean myWorkCopy;

    public static boolean addIntegration(Integration<?> integration) {
        return INTEGRATIONS.add(integration);
    }

    public static boolean addPresolver(Presolver presolver) {
        return PRESOLVERS.add(presolver);
    }

    public static void clearIntegrations() {
        INTEGRATIONS.clear();
    }

    public static void clearPresolvers() {
        PRESOLVERS.clear();
    }

    public static boolean removeIntegration(Integration<?> integration) {
        return INTEGRATIONS.remove(integration);
    }

    public static boolean removePresolver(Presolver presolver) {
        return PRESOLVERS.remove(presolver);
    }

    public ExpressionsBasedModel() {
        this.myWorkCopy = false;
    }

    public ExpressionsBasedModel(Collection<? extends Variable> variables) {
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
        this.myWorkCopy = false;
    }

    public ExpressionsBasedModel(Variable ... variables) {
        for (Variable tmpVariable : variables) {
            this.addVariable(tmpVariable);
        }
        this.myWorkCopy = false;
    }

    ExpressionsBasedModel(ExpressionsBasedModel modelToCopy, boolean workCopy) {
        super(modelToCopy.options);
        this.setMinimisation(modelToCopy.isMinimisation());
        for (Variable tmpVariable : modelToCopy.getVariables()) {
            this.addVariable(tmpVariable.copy());
        }
        for (Expression tmpExpression : modelToCopy.getExpressions()) {
            this.myExpressions.put(tmpExpression.getName(), tmpExpression.copy(this, !workCopy));
        }
        this.myWorkCopy = workCopy;
        if (this.myWorkCopy) {
            this.myFixedVariables.addAll(modelToCopy.getFixedVariables());
        }
    }

    ExpressionsBasedModel(Optimisation.Options someOptions) {
        super(someOptions);
        this.myWorkCopy = false;
    }

    public Expression addExpression(String name) {
        Expression retVal = new Expression(name, this);
        this.myExpressions.put(name, retVal);
        return retVal;
    }

    public void addVariable(Variable variable) {
        if (this.myWorkCopy) {
            throw new IllegalStateException("This model is a copy - its set of variables cannot be modified!");
        }
        this.myVariables.add(variable);
        variable.setIndex(new IntIndex(this.myVariables.size() - 1));
    }

    public void addVariables(Collection<? extends Variable> variables) {
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
    }

    public Stream<Variable> bounds() {
        return this.variables().filter(v -> v.isConstraint());
    }

    public Stream<Expression> constraints() {
        return this.myExpressions.values().stream().filter(c -> c.isConstraint() && !c.isRedundant());
    }

    public ExpressionsBasedModel copy() {
        return new ExpressionsBasedModel(this, false);
    }

    public int countExpressions() {
        return this.myExpressions.size();
    }

    public int countVariables() {
        return this.myVariables.size();
    }

    @Override
    public void dispose() {
        this.flushCaches();
        for (Expression tmpExprerssion : this.myExpressions.values()) {
            tmpExprerssion.destroy();
        }
        this.myExpressions.clear();
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.destroy();
        }
        this.myVariables.clear();
        this.myFixedVariables.clear();
    }

    public Expression getExpression(String name) {
        return this.myExpressions.get(name);
    }

    public Collection<Expression> getExpressions() {
        return Collections.unmodifiableCollection(this.myExpressions.values());
    }

    public Set<IntIndex> getFixedVariables() {
        return Collections.unmodifiableSet(this.myFixedVariables);
    }

    public List<Variable> getFreeVariables() {
        if (this.myFreeIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myFreeVariables);
    }

    public List<Variable> getIntegerVariables() {
        if (this.myIntegerIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myIntegerVariables);
    }

    public List<Variable> getNegativeVariables() {
        if (this.myNegativeIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myNegativeVariables);
    }

    public Expression getObjectiveExpression() {
        Expression myObjectiveExpression = new Expression(OBJECTIVE, this);
        for (int i = 0; i < this.myVariables.size(); ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (!tmpVariable.isObjective()) continue;
            myObjectiveExpression.set(i, (Number)tmpVariable.getContributionWeight());
        }
        BigDecimal tmpOldVal = null;
        BigDecimal tmpDiff = null;
        BigDecimal tmpNewVal = null;
        for (Expression tmpExpression : this.myExpressions.values()) {
            BigDecimal value;
            boolean tmpNotOne;
            if (!tmpExpression.isObjective()) continue;
            BigDecimal tmpContributionWeight = tmpExpression.getContributionWeight();
            boolean bl = tmpNotOne = tmpContributionWeight.compareTo(BigMath.ONE) != 0;
            if (tmpExpression.isAnyLinearFactorNonZero()) {
                for (IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    tmpOldVal = myObjectiveExpression.get(intIndex);
                    tmpDiff = tmpExpression.get(intIndex);
                    value = tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                    myObjectiveExpression.set(intIndex, (Number)value);
                }
            }
            if (!tmpExpression.isAnyQuadraticFactorNonZero()) continue;
            for (IntRowColumn intRowColumn : tmpExpression.getQuadraticKeySet()) {
                tmpOldVal = myObjectiveExpression.get(intRowColumn);
                tmpDiff = tmpExpression.get(intRowColumn);
                value = tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                myObjectiveExpression.set(intRowColumn, (Number)value);
            }
        }
        return myObjectiveExpression;
    }

    @Deprecated
    public MultiaryFunction.TwiceDifferentiable<Double> getObjectiveFunction() {
        return this.objective().toFunction();
    }

    public List<Variable> getPositiveVariables() {
        if (this.myPositiveIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myPositiveVariables);
    }

    public Variable getVariable(int index) {
        return this.myVariables.get(index);
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.myVariables);
    }

    public Optimisation.Result getVariableValues() {
        return this.getVariableValues(this.options.slack);
    }

    public Optimisation.Result getVariableValues(NumberContext validationContext) {
        int tmpNumberOfVariables = this.myVariables.size();
        Optimisation.State retState = Optimisation.State.UNEXPLORED;
        double retValue = Double.NaN;
        Access1D retSolution = Array1D.BIG.makeZero(tmpNumberOfVariables);
        boolean tmpAllVarsSomeInfo = true;
        for (int i = 0; i < tmpNumberOfVariables; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.getValue() != null) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getValue());
                continue;
            }
            if (tmpVariable.isEqualityConstraint()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isLowerLimitSet() && tmpVariable.isUpperLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)BigFunction.DIVIDE.invoke(tmpVariable.getLowerLimit().add(tmpVariable.getUpperLimit()), BigMath.TWO));
                continue;
            }
            if (tmpVariable.isLowerLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isUpperLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getUpperLimit());
                continue;
            }
            ((Array1D)retSolution).set(i, (Object)BigMath.ZERO);
            tmpAllVarsSomeInfo = false;
        }
        if (tmpAllVarsSomeInfo) {
            if (this.validate(retSolution, validationContext)) {
                retState = Optimisation.State.FEASIBLE;
                retValue = this.getObjectiveExpression().evaluate(retSolution).doubleValue();
            } else {
                retState = Optimisation.State.APPROXIMATE;
            }
        } else {
            retState = Optimisation.State.INFEASIBLE;
        }
        return new Optimisation.Result(retState, retValue, retSolution);
    }

    public int indexOf(Variable variable) {
        return variable.getIndex().index;
    }

    public int indexOfFreeVariable(int globalIndex) {
        return this.myFreeIndices[globalIndex];
    }

    public int indexOfFreeVariable(IntIndex variableIndex) {
        return this.indexOfFreeVariable(variableIndex.index);
    }

    public int indexOfFreeVariable(Variable variable) {
        return this.indexOfFreeVariable(this.indexOf(variable));
    }

    public int indexOfIntegerVariable(int globalIndex) {
        return this.myIntegerIndices[globalIndex];
    }

    public int indexOfIntegerVariable(IntIndex variableIndex) {
        return this.indexOfIntegerVariable(variableIndex.index);
    }

    public int indexOfIntegerVariable(Variable variable) {
        return this.indexOfIntegerVariable(variable.getIndex().index);
    }

    public int indexOfNegativeVariable(int globalIndex) {
        return this.myNegativeIndices[globalIndex];
    }

    public int indexOfNegativeVariable(IntIndex variableIndex) {
        return this.indexOfNegativeVariable(variableIndex.index);
    }

    public int indexOfNegativeVariable(Variable variable) {
        return this.indexOfNegativeVariable(this.indexOf(variable));
    }

    public int indexOfPositiveVariable(int globalIndex) {
        return this.myPositiveIndices[globalIndex];
    }

    public int indexOfPositiveVariable(IntIndex variableIndex) {
        return this.indexOfPositiveVariable(variableIndex.index);
    }

    public int indexOfPositiveVariable(Variable variable) {
        return this.indexOfPositiveVariable(this.indexOf(variable));
    }

    public boolean isAnyExpressionQuadratic() {
        boolean retVal;
        String tmpExpressionKey;
        Expression tmpExpression;
        Iterator<String> tmpIterator = this.myExpressions.keySet().iterator();
        for (retVal = false; !retVal && tmpIterator.hasNext(); retVal |= (tmpExpression = this.myExpressions.get(tmpExpressionKey = tmpIterator.next())).isAnyQuadraticFactorNonZero() && (tmpExpression.isConstraint() || tmpExpression.isObjective())) {
        }
        return retVal;
    }

    public boolean isAnyVariableFixed() {
        return this.myFixedVariables.size() >= 1;
    }

    public boolean isAnyVariableInteger() {
        boolean retVal = false;
        int tmpLength = this.myVariables.size();
        for (int i = 0; !retVal && i < tmpLength; retVal |= this.myVariables.get(i).isInteger(), ++i) {
        }
        return retVal;
    }

    public boolean isWorkCopy() {
        return this.myWorkCopy;
    }

    public void limitObjective(BigDecimal lower, BigDecimal upper) {
        Expression tmpEpression = this.myExpressions.get(OBJ_FUNC_AS_CONSTR_KEY);
        if (tmpEpression == null) {
            tmpEpression = this.getObjectiveExpression().copy(this, false);
            this.myExpressions.put(OBJ_FUNC_AS_CONSTR_KEY, tmpEpression);
        }
        ((Expression)tmpEpression.lower(lower)).upper(upper);
    }

    @Override
    public Optimisation.Result maximise() {
        this.setMaximisation();
        Optimisation.Result tmpSolverResult = this.solve(this.getVariableValues());
        return this.handleResult(tmpSolverResult);
    }

    @Override
    public Optimisation.Result minimise() {
        this.setMinimisation();
        Optimisation.Result tmpSolverResult = this.solve(this.getVariableValues());
        return this.handleResult(tmpSolverResult);
    }

    public Expression objective() {
        return this.getObjectiveExpression();
    }

    public ExpressionsBasedModel relax(boolean inPlace) {
        ExpressionsBasedModel retVal = inPlace ? this : new ExpressionsBasedModel(this, true);
        for (Variable tmpVariable : retVal.getVariables()) {
            tmpVariable.relax();
        }
        return retVal;
    }

    @Deprecated
    public List<Expression> selectExpressions() {
        return this.constraints().collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsLinearEquality() {
        return this.constraints().filter(c -> c.isEqualityConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsLinearLower() {
        return this.constraints().filter(c -> c.isLowerConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsLinearUpper() {
        return this.constraints().filter(c -> c.isUpperConstraint() && !c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsQuadraticEquality() {
        return this.constraints().filter(c -> c.isEqualityConstraint() && c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsQuadraticLower() {
        return this.constraints().filter(c -> c.isLowerConstraint() && c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Expression> selectExpressionsQuadraticUpper() {
        return this.constraints().filter(c -> c.isUpperConstraint() && c.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesFreeLower() {
        return this.bounds().filter(c -> c.isLowerConstraint()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesFreeUpper() {
        return this.bounds().filter(c -> c.isUpperConstraint()).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesNegativeLower() {
        return this.bounds().filter(c -> c.isNegative() && c.isLowerConstraint() && c.getLowerLimit().signum() < 0).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesNegativeUpper() {
        return this.bounds().filter(c -> c.isNegative() && c.isUpperConstraint() && c.getUpperLimit().signum() < 0).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesPositiveLower() {
        return this.bounds().filter(c -> c.isPositive() && c.isLowerConstraint() && c.getLowerLimit().signum() > 0).collect(Collectors.toList());
    }

    @Deprecated
    public List<Variable> selectVariablesPositiveUpper() {
        return this.bounds().filter(c -> c.isPositive() && c.isUpperConstraint() && c.getUpperLimit().signum() > 0).collect(Collectors.toList());
    }

    public Optimisation.Result solve(Optimisation.Result initialSolution) {
        Optimisation.Result retVal = null;
        this.presolve();
        if (this.isInfeasible()) {
            Optimisation.Result tmpSolution = this.getVariableValues();
            retVal = new Optimisation.Result(Optimisation.State.INFEASIBLE, tmpSolution);
        } else if (this.isFixed()) {
            Optimisation.Result tmpSolution = this.getVariableValues();
            retVal = tmpSolution.getState().isFeasible() ? new Optimisation.Result(Optimisation.State.DISTINCT, tmpSolution) : new Optimisation.Result(Optimisation.State.INVALID, tmpSolution);
        } else {
            Integration<?> tmpIntegration = this.getIntegration();
            Object tmpSolver = tmpIntegration.build(this);
            retVal = tmpIntegration.toSolverState(initialSolution, this);
            retVal = tmpSolver.solve(retVal);
            retVal = tmpIntegration.toModelState(retVal, this);
            tmpSolver.dispose();
        }
        return retVal;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(START_END);
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.appendToString(retVal);
            retVal.append(NEW_LINE);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            tmpExpression.appendToString(retVal, this.getVariableValues());
            retVal.append(NEW_LINE);
        }
        return retVal.append(START_END).toString();
    }

    @Override
    public boolean validate() {
        boolean retVal = true;
        for (Variable tmpVariable : this.myVariables) {
            retVal &= tmpVariable.validate(this.options.debug_appender);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            retVal &= tmpExpression.validate(this.options.debug_appender);
        }
        return retVal;
    }

    public boolean validate(Access1D<BigDecimal> solution) {
        return this.validate(solution, this.options.slack);
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context) {
        int tmpSize = this.myVariables.size();
        boolean retVal = (long)tmpSize == solution.count();
        for (int i = 0; retVal && i < tmpSize; retVal &= this.myVariables.get(i).validate(solution.get(i), context, this.options.debug_appender), ++i) {
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            retVal &= retVal && tmpExpression.validate(solution, context, this.options.debug_appender);
        }
        return retVal;
    }

    public boolean validate(NumberContext context) {
        return this.getVariableValues(context).getState().isFeasible();
    }

    public Stream<Variable> variables() {
        return this.myVariables.stream().filter(v -> !v.isEqualityConstraint());
    }

    private Set<IntIndex> identifyFixedVariables() {
        int tmpLength = this.myVariables.size();
        for (int i = 0; i < tmpLength; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (!tmpVariable.isEqualityConstraint()) continue;
            tmpVariable.setValue(tmpVariable.getLowerLimit());
            this.myFixedVariables.add(tmpVariable.getIndex());
        }
        return this.getFixedVariables();
    }

    private Set<IntIndex> categoriseVariables() {
        int tmpLength = this.myVariables.size();
        this.myFreeVariables.clear();
        this.myFreeIndices = new int[tmpLength];
        Arrays.fill(this.myFreeIndices, -1);
        this.myPositiveVariables.clear();
        this.myPositiveIndices = new int[tmpLength];
        Arrays.fill(this.myPositiveIndices, -1);
        this.myNegativeVariables.clear();
        this.myNegativeIndices = new int[tmpLength];
        Arrays.fill(this.myNegativeIndices, -1);
        this.myIntegerVariables.clear();
        this.myIntegerIndices = new int[tmpLength];
        Arrays.fill(this.myIntegerIndices, -1);
        for (int i = 0; i < tmpLength; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.isEqualityConstraint()) {
                tmpVariable.setValue(tmpVariable.getLowerLimit());
                this.myFixedVariables.add(tmpVariable.getIndex());
                continue;
            }
            this.myFreeVariables.add(tmpVariable);
            this.myFreeIndices[i] = this.myFreeVariables.size() - 1;
            if (!tmpVariable.isUpperLimitSet() || tmpVariable.getUpperLimit().signum() == 1) {
                this.myPositiveVariables.add(tmpVariable);
                this.myPositiveIndices[i] = this.myPositiveVariables.size() - 1;
            }
            if (!tmpVariable.isLowerLimitSet() || tmpVariable.getLowerLimit().signum() == -1) {
                this.myNegativeVariables.add(tmpVariable);
                this.myNegativeIndices[i] = this.myNegativeVariables.size() - 1;
            }
            if (!tmpVariable.isInteger()) continue;
            this.myIntegerVariables.add(tmpVariable);
            this.myIntegerIndices[i] = this.myIntegerVariables.size() - 1;
        }
        return this.getFixedVariables();
    }

    private Optimisation.Result handleResult(Optimisation.Result solverResult) {
        NumberContext tmpSolutionContext = this.options.solution;
        int tmpSize = this.myVariables.size();
        for (int i = 0; i < tmpSize; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (this.myFixedVariables.contains(tmpVariable.getIndex())) continue;
            tmpVariable.setValue(tmpSolutionContext.enforce(solverResult.get(i)));
        }
        Optimisation.Result tmpSolution = this.getVariableValues();
        Optimisation.State tmpState = solverResult.getState();
        double tmpValue = this.getObjectiveExpression().evaluate(tmpSolution).doubleValue();
        if (this.options.validate) {
            // empty if block
        }
        return new Optimisation.Result(tmpState, tmpValue, tmpSolution);
    }

    protected void flushCaches() {
        this.myFreeVariables.clear();
        this.myFreeIndices = null;
        this.myPositiveVariables.clear();
        this.myPositiveIndices = null;
        this.myNegativeVariables.clear();
        this.myNegativeIndices = null;
        this.myIntegerVariables.clear();
        this.myIntegerIndices = null;
    }

    Integration<?> getIntegration() {
        Integration retVal = null;
        for (Integration<?> tmpIntegration : INTEGRATIONS) {
            if (!tmpIntegration.isCapable(this)) continue;
            retVal = tmpIntegration;
            break;
        }
        if (retVal == null) {
            retVal = this.isAnyVariableInteger() ? new ExpressionsBasedIntegerIntegration() : (this.isAnyExpressionQuadratic() ? new ExpressionsBasedConvexIntegration() : new ExpressionsBasedLinearIntegration());
        }
        return retVal;
    }

    boolean isFixed() {
        return this.myFixedVariables.size() == this.myVariables.size();
    }

    boolean isInfeasible() {
        for (Expression tmpExpression : this.myExpressions.values()) {
            if (!tmpExpression.isInfeasible()) continue;
            return true;
        }
        return false;
    }

    final void presolve() {
        boolean tmpNeedToRepeat = false;
        do {
            Set<IntIndex> tmpFixedVariables = this.identifyFixedVariables();
            tmpNeedToRepeat = false;
            for (Expression tmpExpr : this.getExpressions()) {
                if (tmpNeedToRepeat || !tmpExpr.isConstraint() || tmpExpr.isInfeasible() || tmpExpr.isRedundant() || tmpExpr.countQuadraticFactors() != 0) continue;
                for (Presolver tmpPreS : PRESOLVERS) {
                    tmpNeedToRepeat |= tmpPreS.simplify(tmpExpr, tmpFixedVariables);
                }
            }
        } while (tmpNeedToRepeat);
        this.categoriseVariables();
    }

    static {
        ExpressionsBasedModel.addPresolver(Presolvers.ZERO_ONE_TWO);
        ExpressionsBasedModel.addPresolver(Presolvers.OPPOSITE_SIGN);
    }

    public static abstract class Presolver
    implements Comparable<Presolver> {
        private final int myExecutionOrder;
        private final UUID myUUID = UUID.randomUUID();

        protected Presolver(int executionOrder) {
            this.myExecutionOrder = executionOrder;
        }

        @Override
        public int compareTo(Presolver reference) {
            return Integer.compare(this.myExecutionOrder, reference.getExecutionOrder());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Presolver)) {
                return false;
            }
            Presolver other = (Presolver)obj;
            return !(this.myUUID == null ? other.myUUID != null : !this.myUUID.equals(other.myUUID));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myUUID == null ? 0 : this.myUUID.hashCode());
            return result;
        }

        public abstract boolean simplify(Expression var1, Set<IntIndex> var2);

        final int getExecutionOrder() {
            return this.myExecutionOrder;
        }
    }

    public static abstract class Integration<S extends Optimisation.Solver>
    implements Optimisation.Integration<ExpressionsBasedModel, S> {
        @Override
        public final Optimisation.Result extractSolverState(ExpressionsBasedModel model) {
            return this.toSolverState(model.getVariableValues(), model);
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            PrimitiveArray tmpModelSolution = PrimitiveArray.make(model.countVariables());
            for (IntIndex tmpFixed : model.getFixedVariables()) {
                tmpModelSolution.set((long)tmpFixed.index, model.getVariable(tmpFixed.index).getValue().doubleValue());
            }
            List<Variable> tmpFreeVariables = model.getFreeVariables();
            for (int f = 0; f < tmpFreeVariables.size(); ++f) {
                Variable tmpVariable = tmpFreeVariables.get(f);
                int tmpIndex = model.indexOf(tmpVariable);
                tmpModelSolution.set((long)tmpIndex, solverState.doubleValue(f));
            }
            return new Optimisation.Result(solverState.getState(), solverState.getValue(), tmpModelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            List<Variable> tmpFreeVariables = model.getFreeVariables();
            PrimitiveArray tmpSolverSolution = PrimitiveArray.make(tmpFreeVariables.size());
            double[] tmpData = tmpSolverSolution.data;
            for (int i = 0; i < tmpData.length; ++i) {
                Variable tmpVariable = tmpFreeVariables.get(i);
                int tmpIndex = model.indexOf(tmpVariable);
                tmpData[i] = modelState.doubleValue(tmpIndex);
            }
            return new Optimisation.Result(modelState.getState(), modelState.getValue(), tmpSolverSolution);
        }
    }
}

