/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;

final class UnconstrainedSolver
extends ConvexSolver {
    UnconstrainedSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected MatrixStore<Double> getIterationKKT() {
        return this.getIterationQ();
    }

    @Override
    protected MatrixStore<Double> getIterationRHS() {
        return this.getIterationC();
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        super.initialise(kickStarter);
        this.resetX();
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return this.countIterations() < 1;
    }

    @Override
    protected void performIteration() {
        MatrixStore<Double> tmpQ = this.getIterationQ();
        MatrixStore<Double> tmpC = this.getIterationC();
        DecompositionStore<Double> tmpX = this.getX();
        boolean tmpSolvable = true;
        tmpSolvable = this.myCholesky.isSolvable();
        if (tmpSolvable) {
            this.myCholesky.solve(tmpC, tmpX);
        } else {
            tmpSolvable = this.myLU.compute(tmpQ);
            if (tmpSolvable) {
                this.myLU.solve(tmpC, tmpX);
            }
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
            this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
        }
        if (tmpSolvable) {
            this.setState(Optimisation.State.DISTINCT);
        } else {
            this.setState(Optimisation.State.UNBOUNDED);
            this.resetX();
        }
    }

    @Override
    final MatrixStore<Double> getIterationC() {
        return this.getC();
    }
}

