/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.util.concurrent.atomic.AtomicInteger;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.optimisation.integer.OldIntegerSolver;

public abstract class IntegerSolver
extends GenericSolver {
    private final MultiaryFunction.TwiceDifferentiable<Double> myFunction;
    private volatile Optimisation.Result myBestResultSoFar = null;
    private final AtomicInteger myIntegerSolutionsCount = new AtomicInteger();
    private final boolean myMinimisation;
    private final NodeStatistics myNodeStatistics = new NodeStatistics();
    private final ExpressionsBasedModel myModel;

    private IntegerSolver(Optimisation.Options solverOptions) {
        this(null, solverOptions);
    }

    protected IntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(solverOptions);
        this.myModel = model;
        this.myFunction = model.objective().toFunction();
        this.myMinimisation = model.isMinimisation();
    }

    protected final boolean isFunctionSet() {
        return this.myFunction != null;
    }

    protected int countIntegerSolutions() {
        return this.myIntegerSolutionsCount.intValue();
    }

    protected Optimisation.Result getBestResultSoFar() {
        Optimisation.Result tmpCurrentlyTheBest = this.myBestResultSoFar;
        if (tmpCurrentlyTheBest != null) {
            return tmpCurrentlyTheBest;
        }
        Optimisation.State tmpSate = Optimisation.State.INVALID;
        double tmpValue = this.myMinimisation ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        Object tmpSolution = MatrixStore.PRIMITIVE.makeZero(this.getModel().countVariables(), 1).get();
        return new Optimisation.Result(tmpSate, tmpValue, (Access1D<?>)tmpSolution);
    }

    protected final ExpressionsBasedModel getModel() {
        return this.myModel;
    }

    protected final boolean isModelSet() {
        return this.myModel != null;
    }

    protected boolean isGoodEnoughToContinueBranching(double nonIntegerValue) {
        Optimisation.Result tmpCurrentlyTheBest = this.myBestResultSoFar;
        if (tmpCurrentlyTheBest == null || Double.isNaN(nonIntegerValue)) {
            return true;
        }
        double tmpBestIntegerValue = tmpCurrentlyTheBest.getValue();
        double tmpMipGap = Math.abs(tmpBestIntegerValue - nonIntegerValue) / Math.abs(tmpBestIntegerValue);
        if (this.myMinimisation) {
            return nonIntegerValue < tmpBestIntegerValue && tmpMipGap > this.options.mip_gap;
        }
        return nonIntegerValue > tmpBestIntegerValue && tmpMipGap > this.options.mip_gap;
    }

    protected boolean isIntegerSolutionFound() {
        return this.myBestResultSoFar != null;
    }

    protected boolean isIterationNecessary() {
        if (this.myBestResultSoFar == null) {
            return true;
        }
        int tmpIterations = this.countIterations();
        long tmpTime = this.countTime();
        return tmpTime < this.options.time_suffice && tmpIterations < this.options.iterations_suffice;
    }

    protected synchronized void markInteger(NodeKey node, Optimisation.Result result) {
        Optimisation.Result tmpCurrentlyTheBest = this.myBestResultSoFar;
        if (tmpCurrentlyTheBest == null) {
            this.myBestResultSoFar = result;
        } else if (this.myMinimisation && result.getValue() < tmpCurrentlyTheBest.getValue()) {
            this.myBestResultSoFar = result;
        } else if (!this.myMinimisation && result.getValue() > tmpCurrentlyTheBest.getValue()) {
            this.myBestResultSoFar = result;
        }
        this.myIntegerSolutionsCount.incrementAndGet();
    }

    protected final MatrixStore<Double> getGradient(Access1D<Double> solution) {
        return this.myFunction.getGradient(solution);
    }

    @Override
    protected final double evaluateFunction(Access1D<?> solution) {
        if (this.myFunction != null && solution != null && (long)this.myFunction.arity() == solution.count()) {
            return this.myFunction.invoke(AccessUtils.asPrimitive1D(solution));
        }
        return Double.NaN;
    }

    public static OldIntegerSolver make(ExpressionsBasedModel model) {
        return new OldIntegerSolver(model, model.options);
    }

    final class NodeStatistics {
        private final AtomicInteger myAbandoned = new AtomicInteger();
        private final AtomicInteger myBranched = new AtomicInteger();
        private final AtomicInteger myExhausted = new AtomicInteger();
        private final AtomicInteger myFailed = new AtomicInteger();
        private final AtomicInteger myInfeasible = new AtomicInteger();
        private final AtomicInteger myTruncated = new AtomicInteger();
        private final AtomicInteger myInteger = new AtomicInteger();

        NodeStatistics() {
        }

        public int countCreated() {
            return this.myTruncated.get() + this.myAbandoned.get() + this.countEvaluated();
        }

        public int countEvaluated() {
            return this.myInfeasible.get() + this.myFailed.get() + this.myExhausted.get() + this.myBranched.get();
        }

        boolean abandoned() {
            this.myAbandoned.incrementAndGet();
            return true;
        }

        boolean branched() {
            this.myBranched.incrementAndGet();
            return true;
        }

        boolean exhausted() {
            this.myExhausted.incrementAndGet();
            return true;
        }

        boolean failed(boolean state) {
            this.myFailed.incrementAndGet();
            return state;
        }

        boolean infeasible() {
            this.myInfeasible.incrementAndGet();
            return true;
        }

        boolean infeasible(boolean state) {
            this.myInfeasible.incrementAndGet();
            return state;
        }

        boolean integer() {
            this.myInteger.incrementAndGet();
            return true;
        }

        boolean truncated(boolean state) {
            this.myTruncated.incrementAndGet();
            return state;
        }
    }
}

