/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.IntIndex;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.BaseSolver;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.linear.SimplexTableauSolver;
import org.ojalgo.type.IndexSelector;

public abstract class LinearSolver
extends BaseSolver {
    static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = PrimitiveDenseStore.FACTORY;
    private final IndexSelector mySelector;

    /*
     * WARNING - void declaration
     */
    public static void copy(ExpressionsBasedModel sourceModel, Builder destinationBuilder) {
        void var33_54;
        int tmpNegInd;
        int tmpPosInd;
        int tmpNegInd2;
        int tmpPosInd2;
        int tmpNegInd3;
        boolean tmpMaximisation = sourceModel.isMaximisation();
        List<Variable> tmpPosVariables = sourceModel.getPositiveVariables();
        List<Variable> tmpNegVariables = sourceModel.getNegativeVariables();
        Set<IntIndex> tmpFixVariables = sourceModel.getFixedVariables();
        Expression tmpObjFunc = sourceModel.getObjectiveExpression().compensate(tmpFixVariables);
        List tmpExprsEq = sourceModel.constraints().filter(c1 -> c1.isEqualityConstraint() && !c1.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsLo = sourceModel.constraints().filter(c2 -> c2.isLowerConstraint() && !c2.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpExprsUp = sourceModel.constraints().filter(c3 -> c3.isUpperConstraint() && !c3.isAnyQuadraticFactorNonZero()).collect(Collectors.toList());
        List tmpVarsPosLo = sourceModel.bounds().filter(c6 -> c6.isPositive() && c6.isLowerConstraint() && c6.getLowerLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsPosUp = sourceModel.bounds().filter(c7 -> c7.isPositive() && c7.isUpperConstraint() && c7.getUpperLimit().signum() > 0).collect(Collectors.toList());
        List tmpVarsNegLo = sourceModel.bounds().filter(c4 -> c4.isNegative() && c4.isLowerConstraint() && c4.getLowerLimit().signum() < 0).collect(Collectors.toList());
        List tmpVarsNegUp = sourceModel.bounds().filter(c5 -> c5.isNegative() && c5.isUpperConstraint() && c5.getUpperLimit().signum() < 0).collect(Collectors.toList());
        int tmpConstraiCount = tmpExprsEq.size() + tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        int tmpProblVarCount = tmpPosVariables.size() + tmpNegVariables.size();
        int tmpSlackVarCount = tmpExprsLo.size() + tmpExprsUp.size() + tmpVarsPosLo.size() + tmpVarsPosUp.size() + tmpVarsNegLo.size() + tmpVarsNegUp.size();
        int tmpTotalVarCount = tmpProblVarCount + tmpSlackVarCount;
        int[] tmpBasis = AccessUtils.makeIncreasingRange(-tmpConstraiCount, tmpConstraiCount);
        PhysicalStore tmpC = (PhysicalStore)FACTORY.makeZero(tmpTotalVarCount, 1L);
        PhysicalStore tmpAE = (PhysicalStore)FACTORY.makeZero(tmpConstraiCount, tmpTotalVarCount);
        PhysicalStore tmpBE = (PhysicalStore)FACTORY.makeZero(tmpConstraiCount, 1L);
        destinationBuilder.objective((MatrixStore)tmpC);
        destinationBuilder.equalities((MatrixStore)tmpAE, (MatrixStore)tmpBE);
        boolean tmpPosVarsBaseIndex = false;
        int tmpNegVarsBaseIndex = 0 + tmpPosVariables.size();
        int tmpSlaVarsBaseIndex = tmpNegVarsBaseIndex + tmpNegVariables.size();
        for (IntIndex tmpKey : tmpObjFunc.getLinearKeySet()) {
            int tmpNegInd4;
            double tmpFactor = tmpMaximisation ? -tmpObjFunc.getAdjustedLinearFactor(tmpKey) : tmpObjFunc.getAdjustedLinearFactor(tmpKey);
            int tmpPosInd3 = sourceModel.indexOfPositiveVariable(tmpKey.index);
            if (tmpPosInd3 >= 0) {
                tmpC.set((long)tmpPosInd3, 0L, tmpFactor);
            }
            if ((tmpNegInd4 = sourceModel.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
            tmpC.set((long)(tmpNegVarsBaseIndex + tmpNegInd4), 0L, -tmpFactor);
        }
        int tmpConstrBaseIndex = 0;
        int tmpCurrentSlackVarIndex = tmpSlaVarsBaseIndex;
        int tmpExprsEqLength = tmpExprsEq.size();
        for (int c = 0; c < tmpExprsEqLength; ++c) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsEq.get(c)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, -tmpRHS);
                for (IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                    int tmpPosInd3 = sourceModel.indexOfPositiveVariable(intIndex.index);
                    if (tmpPosInd3 >= 0) {
                        tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd3), -tmpFactor);
                    }
                    if ((tmpNegInd3 = sourceModel.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd3), tmpFactor);
                }
                continue;
            }
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, tmpRHS);
            for (IntIndex intIndex : tmpExpr.getLinearKeySet()) {
                int tmpNegInd32;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(intIndex);
                int tmpPosInd4 = sourceModel.indexOfPositiveVariable(intIndex.index);
                if (tmpPosInd4 >= 0) {
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd4), tmpFactor);
                }
                if ((tmpNegInd32 = sourceModel.indexOfNegativeVariable(intIndex.index)) < 0) continue;
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd32), -tmpFactor);
            }
        }
        tmpConstrBaseIndex += tmpExprsEqLength;
        int tmpExprsLoLength = tmpExprsLo.size();
        for (int c = 0; c < tmpExprsLoLength; ++c) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsLo.get(c)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedLowerLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, -tmpRHS);
                tmpBasis[tmpConstrBaseIndex + c] = tmpCurrentSlackVarIndex;
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
                for (IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd2 = sourceModel.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd2 >= 0) {
                        tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd2), -tmpFactor);
                    }
                    if ((tmpNegInd2 = sourceModel.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd2), tmpFactor);
                }
                continue;
            }
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, tmpRHS);
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
            for (IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                int tmpNegInd22;
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                int tmpPosInd22 = sourceModel.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd22 >= 0) {
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd22), tmpFactor);
                }
                if ((tmpNegInd22 = sourceModel.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd22), -tmpFactor);
            }
        }
        tmpConstrBaseIndex += tmpExprsLoLength;
        int tmpExprsUpLength = tmpExprsUp.size();
        for (int c = 0; c < tmpExprsUpLength; ++c) {
            double tmpFactor;
            Expression tmpExpr = ((Expression)tmpExprsUp.get(c)).compensate(tmpFixVariables);
            double tmpRHS = tmpExpr.getAdjustedUpperLimit();
            if (tmpRHS < PrimitiveMath.ZERO) {
                tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, -tmpRHS);
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
                for (IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                    tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                    tmpPosInd = sourceModel.indexOfPositiveVariable(tmpKey.index);
                    if (tmpPosInd >= 0) {
                        tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd), -tmpFactor);
                    }
                    if ((tmpNegInd = sourceModel.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd), tmpFactor);
                }
                continue;
            }
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, tmpRHS);
            tmpBasis[tmpConstrBaseIndex + c] = tmpCurrentSlackVarIndex;
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
            for (IntIndex tmpKey : tmpExpr.getLinearKeySet()) {
                tmpFactor = tmpExpr.getAdjustedLinearFactor(tmpKey);
                tmpPosInd = sourceModel.indexOfPositiveVariable(tmpKey.index);
                if (tmpPosInd >= 0) {
                    tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd), tmpFactor);
                }
                if ((tmpNegInd = sourceModel.indexOfNegativeVariable(tmpKey.index)) < 0) continue;
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd), -tmpFactor);
            }
        }
        tmpConstrBaseIndex += tmpExprsUpLength;
        int tmpVarsPosLoLength = tmpVarsPosLo.size();
        for (int c = 0; c < tmpVarsPosLoLength; ++c) {
            Variable tmpVar = (Variable)tmpVarsPosLo.get(c);
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, tmpVar.getAdjustedLowerLimit());
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
            int n = sourceModel.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd5 = sourceModel.indexOfPositiveVariable(n);
            if (tmpPosInd5 >= 0) {
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd5), tmpFactor);
            }
            if ((tmpNegInd3 = sourceModel.indexOfNegativeVariable(n)) < 0) continue;
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd3), -tmpFactor);
        }
        tmpConstrBaseIndex += tmpVarsPosLoLength;
        int tmpVarsPosUpLength = tmpVarsPosUp.size();
        for (int c = 0; c < tmpVarsPosUpLength; ++c) {
            Variable variable = (Variable)tmpVarsPosUp.get(c);
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, variable.getAdjustedUpperLimit());
            tmpBasis[tmpConstrBaseIndex + c] = tmpCurrentSlackVarIndex;
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
            int tmpKey = sourceModel.indexOf(variable);
            double tmpFactor = variable.getAdjustmentFactor();
            tmpPosInd2 = sourceModel.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd2 >= 0) {
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd2), tmpFactor);
            }
            if ((tmpNegInd2 = sourceModel.indexOfNegativeVariable(tmpKey)) < 0) continue;
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd2), -tmpFactor);
        }
        tmpConstrBaseIndex += tmpVarsPosUpLength;
        int tmpVarsNegLoLength = tmpVarsNegLo.size();
        boolean bl = false;
        while (var33_54 < tmpVarsNegLoLength) {
            Variable tmpVar = (Variable)tmpVarsNegLo.get((int)var33_54);
            tmpBE.set((long)(tmpConstrBaseIndex + var33_54), 0L, -tmpVar.getAdjustedLowerLimit());
            tmpBasis[tmpConstrBaseIndex + var33_54] = tmpCurrentSlackVarIndex;
            tmpAE.set((long)(tmpConstrBaseIndex + var33_54), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.ONE);
            int tmpKey = sourceModel.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            tmpPosInd = sourceModel.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd >= 0) {
                tmpAE.set((long)(tmpConstrBaseIndex + var33_54), (long)(0 + tmpPosInd), -tmpFactor);
            }
            if ((tmpNegInd = sourceModel.indexOfNegativeVariable(tmpKey)) >= 0) {
                tmpAE.set((long)(tmpConstrBaseIndex + var33_54), (long)(tmpNegVarsBaseIndex + tmpNegInd), tmpFactor);
            }
            ++var33_54;
        }
        tmpConstrBaseIndex += tmpVarsNegLoLength;
        int n = tmpVarsNegUp.size();
        for (int c = 0; c < n; ++c) {
            int tmpNegInd5;
            Variable tmpVar = (Variable)tmpVarsNegUp.get(c);
            tmpBE.set((long)(tmpConstrBaseIndex + c), 0L, -tmpVar.getAdjustedUpperLimit());
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)tmpCurrentSlackVarIndex++, PrimitiveMath.NEG);
            int tmpKey = sourceModel.indexOf(tmpVar);
            double tmpFactor = tmpVar.getAdjustmentFactor();
            int tmpPosInd6 = sourceModel.indexOfPositiveVariable(tmpKey);
            if (tmpPosInd6 >= 0) {
                tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(0 + tmpPosInd6), -tmpFactor);
            }
            if ((tmpNegInd5 = sourceModel.indexOfNegativeVariable(tmpKey)) < 0) continue;
            tmpAE.set((long)(tmpConstrBaseIndex + c), (long)(tmpNegVarsBaseIndex + tmpNegInd5), tmpFactor);
        }
        tmpConstrBaseIndex += n;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(MatrixStore<Double> C) {
        return LinearSolver.getBuilder().objective((MatrixStore)C);
    }

    protected LinearSolver(BaseSolver.AbstractBuilder<Builder, LinearSolver> matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        this.mySelector = new IndexSelector(matrices.countVariables());
    }

    @Deprecated
    public abstract int[] getBasis();

    @Deprecated
    public abstract double[] getResidualCosts();

    protected final int countBasisDeficit() {
        return this.countEqualityConstraints() - this.mySelector.countIncluded();
    }

    protected final int countConstraints() {
        return this.countEqualityConstraints();
    }

    protected final void exclude(int anIndexToExclude) {
        this.mySelector.exclude(anIndexToExclude);
    }

    protected final void excludeAll() {
        this.mySelector.excludeAll();
    }

    protected final int[] getExcluded() {
        return this.mySelector.getExcluded();
    }

    protected final int[] getIncluded() {
        return this.mySelector.getIncluded();
    }

    protected final boolean hasConstraints() {
        return this.hasEqualityConstraints();
    }

    protected final void include(int anIndexToInclude) {
        this.mySelector.include(anIndexToInclude);
    }

    protected final void include(int[] someIndecesToInclude) {
        this.mySelector.include(someIndecesToInclude);
    }

    public static final class Builder
    extends BaseSolver.AbstractBuilder<Builder, LinearSolver> {
        public Builder(MatrixStore<Double> C) {
            super(C);
        }

        Builder() {
        }

        Builder(BaseSolver.AbstractBuilder<Builder, LinearSolver> matrices) {
            super(matrices);
        }

        Builder(MatrixStore<Double> Q, MatrixStore<Double> C) {
            super(Q, C);
        }

        Builder(MatrixStore<Double>[] aMtrxArr) {
            super(aMtrxArr);
        }

        @Override
        public LinearSolver build(Optimisation.Options options) {
            this.validate();
            return new SimplexTableauSolver(this, options);
        }

        @Override
        public Builder equalities(MatrixStore<Double> AE, MatrixStore<Double> BE) {
            return (Builder)super.equalities(AE, BE);
        }

        @Override
        public Builder objective(MatrixStore<Double> C) {
            return (Builder)super.objective(C);
        }
    }
}

