/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.Normal;
import org.ojalgo.random.SampleSet;

public class LogNormal
extends AbstractContinuous {
    private static final long serialVersionUID = 2175858399667617840L;
    private final Normal myNormal;

    public static LogNormal estimate(Access1D<?> rawSamples) {
        int tmpSize = (int)rawSamples.count();
        Access1D tmpLogSamples = Array1D.PRIMITIVE.makeZero(tmpSize);
        for (int i = 0; i < tmpSize; ++i) {
            ((Array1D)tmpLogSamples).set((long)i, Math.log(rawSamples.doubleValue(i)));
        }
        SampleSet tmpSampleSet = SampleSet.wrap(tmpLogSamples);
        return new LogNormal(tmpSampleSet.getMean(), tmpSampleSet.getStandardDeviation());
    }

    public static LogNormal make(double aExpected, double aVariance) {
        double tmpVar = Math.log1p(aVariance / (aExpected * aExpected));
        double tmpMean = Math.log(aExpected) - PrimitiveMath.HALF * tmpVar;
        double tmpStdDev = Math.sqrt(tmpVar);
        return new LogNormal(tmpMean, tmpStdDev);
    }

    public LogNormal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public LogNormal(double aMean, double aStdDev) {
        this.myNormal = new Normal(aMean, aStdDev);
    }

    @Override
    public double getDistribution(double aValue) {
        return this.myNormal.getDistribution(Math.log(aValue));
    }

    @Override
    public double getExpected() {
        return Math.exp(this.myNormal.getExpected() + this.myNormal.getVariance() * PrimitiveMath.HALF);
    }

    public double getGeometricMean() {
        return Math.exp(this.myNormal.getExpected());
    }

    public double getGeometricStandardDeviation() {
        return Math.exp(this.myNormal.getStandardDeviation());
    }

    @Override
    public double getProbability(double aValue) {
        return this.myNormal.getProbability(Math.log(aValue)) / aValue;
    }

    @Override
    public double getQuantile(double aProbality) {
        this.checkProbabilty(aProbality);
        return Math.exp(this.myNormal.getQuantile(aProbality));
    }

    @Override
    public double getVariance() {
        double tmpVariance = this.myNormal.getVariance();
        return Math.expm1(tmpVariance) * Math.exp(PrimitiveMath.TWO * this.myNormal.getExpected() + tmpVariance);
    }

    @Override
    protected double generate() {
        return Math.exp(this.myNormal.generate());
    }
}

