/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.AbstractDiscrete;
import org.ojalgo.random.RandomUtils;

public class Poisson
extends AbstractDiscrete {
    private static final long serialVersionUID = -5382163736545207782L;
    private final double myLambda;

    public Poisson() {
        this(PrimitiveMath.ONE);
    }

    public Poisson(double aLambda) {
        this.myLambda = aLambda;
    }

    @Override
    public double getExpected() {
        return this.myLambda;
    }

    @Override
    public double getProbability(int aVal) {
        return Math.exp(-this.myLambda) * Math.pow(this.myLambda, aVal) / RandomUtils.factorial(aVal);
    }

    @Override
    public double getVariance() {
        return this.myLambda;
    }

    @Override
    protected double generate() {
        int retVal = -1;
        for (double tmpVal = PrimitiveMath.ZERO; tmpVal <= PrimitiveMath.ONE; tmpVal -= Math.log(this.random().nextDouble()) / this.myLambda) {
            ++retVal;
        }
        return retVal;
    }
}

