/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.random.ContinuousDistribution;
import org.ojalgo.random.Random1D;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.RandomProcess;

abstract class Process1D<D extends ContinuousDistribution, P extends AbstractProcess<D>> {
    private final Random1D myGenerator;
    private final AbstractProcess<? extends D>[] myProcesses;

    private Process1D() {
        this(null, null);
    }

    protected Process1D(Access2D<?> aCorrelationsMatrix, List<? extends P> someProcs) {
        this.myGenerator = new Random1D(aCorrelationsMatrix);
        this.myProcesses = someProcs.toArray(new AbstractProcess[someProcs.size()]);
    }

    protected Process1D(List<? extends P> someProcs) {
        int tmpSize = someProcs.size();
        this.myGenerator = new Random1D(tmpSize);
        this.myProcesses = someProcs.toArray(new AbstractProcess[tmpSize]);
    }

    public double getValue(int index) {
        return this.myProcesses[index].getValue();
    }

    public PrimitiveArray getValues() {
        int tmpLength = this.myProcesses.length;
        PrimitiveArray retVal = PrimitiveArray.make(tmpLength);
        for (int p = 0; p < tmpLength; ++p) {
            retVal.set((long)p, this.myProcesses[p].getValue());
        }
        return retVal;
    }

    public void setValue(int index, double newValue) {
        this.myProcesses[index].setValue(newValue);
    }

    public void setValues(Access1D<?> aValue) {
        for (int p = 0; p < this.myProcesses.length; ++p) {
            this.myProcesses[p].setValue(aValue.doubleValue(p));
        }
    }

    public int size() {
        return this.myProcesses.length;
    }

    public Array1D<Double> step(double aStepSize) {
        Array1D<Double> retVal = this.myGenerator.nextGaussian();
        for (int p = 0; p < this.myProcesses.length; ++p) {
            retVal.set((long)p, this.myProcesses[p].step(this.getValue(p), aStepSize, retVal.doubleValue(p)));
        }
        return retVal;
    }

    protected AbstractProcess<?> getProcess(int index) {
        return this.myProcesses[index];
    }

    D getDistribution(int index, double aStepSize) {
        return (D)((ContinuousDistribution)this.myProcesses[index].getDistribution(aStepSize));
    }

    double getExpected(int index, double aStepSize) {
        return this.myProcesses[index].getExpected(aStepSize);
    }

    double getLowerConfidenceQuantile(int index, double aStepSize, double aConfidence) {
        return this.myProcesses[index].getLowerConfidenceQuantile(aStepSize, aConfidence);
    }

    double getStandardDeviation(int index, double aStepSize) {
        return this.myProcesses[index].getStandardDeviation(aStepSize);
    }

    double getUpperConfidenceQuantile(int index, double aStepSize, double aConfidence) {
        return this.myProcesses[index].getUpperConfidenceQuantile(aStepSize, aConfidence);
    }

    double getVariance(int index, double aStepSize) {
        return this.myProcesses[index].getVariance(aStepSize);
    }

    RandomProcess.SimulationResults simulate(int index, int aNumberOfRealisations, int aNumberOfSteps, double aStepSize) {
        return this.myProcesses[index].simulate(aNumberOfRealisations, aNumberOfSteps, aStepSize);
    }

    double step(int index, double aStepSize) {
        return this.myProcesses[index].step(aStepSize);
    }
}

