/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.type.Colour;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.keyvalue.KeyValue;

abstract class AbstractSeries<K extends Comparable<K>, V extends Number, I extends AbstractSeries<K, V, I>>
extends TreeMap<K, V>
implements BasicSeries<K, V> {
    private Colour myColour = null;
    private String myName = null;

    protected AbstractSeries() {
    }

    protected AbstractSeries(Comparator<? super K> someC) {
        super(someC);
    }

    protected AbstractSeries(Map<? extends K, ? extends V> someM) {
        super(someM);
    }

    protected AbstractSeries(SortedMap<K, ? extends V> someM) {
        super(someM);
    }

    public I colour(Colour aPaint) {
        this.myColour = aPaint;
        return (I)this;
    }

    @Override
    public V firstValue() {
        return (V)((Number)this.get(this.firstKey()));
    }

    @Override
    public Colour getColour() {
        return this.myColour;
    }

    @Override
    public DataSeries getDataSeries() {
        return DataSeries.wrap(this.getPrimitiveValues());
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public double[] getPrimitiveValues() {
        double[] retVal = new double[this.size()];
        int i = 0;
        for (Number tmpValue : this.values()) {
            retVal[i] = tmpValue.doubleValue();
            ++i;
        }
        return retVal;
    }

    @Override
    public V lastValue() {
        return (V)((Number)this.get(this.lastKey()));
    }

    @Override
    public void modify(BasicSeries<K, V> aLeftArg, BinaryFunction<V> aFunc) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            Comparable tmpKey = (Comparable)tmpEntry.getKey();
            Number tmpLeftArg = (Number)aLeftArg.get(tmpKey);
            if (tmpLeftArg != null) {
                this.put(tmpKey, aFunc.invoke(tmpLeftArg, (Number)tmpEntry.getValue()));
                continue;
            }
            this.remove(tmpKey);
        }
    }

    @Override
    public void modify(BinaryFunction<V> aFunc, BasicSeries<K, V> aRightArg) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            Comparable tmpKey = (Comparable)tmpEntry.getKey();
            Number tmpRightArg = (Number)aRightArg.get(tmpKey);
            if (tmpRightArg != null) {
                this.put(tmpKey, aFunc.invoke((Number)tmpEntry.getValue(), tmpRightArg));
                continue;
            }
            this.remove(tmpKey);
        }
    }

    @Override
    public void modify(BinaryFunction<V> aFunc, V aRightArg) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            this.put(tmpEntry.getKey(), aFunc.invoke((Number)tmpEntry.getValue(), aRightArg));
        }
    }

    @Override
    public void modify(ParameterFunction<V> aFunc, int aParam) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            this.put(tmpEntry.getKey(), aFunc.invoke((Number)tmpEntry.getValue(), aParam));
        }
    }

    @Override
    public void modify(UnaryFunction<V> aFunc) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            this.put(tmpEntry.getKey(), aFunc.invoke((Number)tmpEntry.getValue()));
        }
    }

    @Override
    public void modify(V aLeftArg, BinaryFunction<V> aFunc) {
        for (Map.Entry tmpEntry : this.entrySet()) {
            this.put(tmpEntry.getKey(), aFunc.invoke(aLeftArg, (Number)tmpEntry.getValue()));
        }
    }

    public I name(String aName) {
        this.myName = aName;
        return (I)this;
    }

    @Override
    public void putAll(Collection<? extends KeyValue<? extends K, ? extends V>> data) {
        for (KeyValue<K, V> tmpKeyValue : data) {
            this.put(tmpKeyValue.getKey(), tmpKeyValue.getValue());
        }
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }

    void appendLastPartToString(StringBuilder retVal) {
        if (this.getColour() != null) {
            retVal.append(TypeUtils.toHexString(this.getColour().getRGB()));
            retVal.append('\u00a0');
        }
        if (this.size() <= 30) {
            retVal.append(super.toString());
        } else {
            retVal.append("First:");
            retVal.append(this.firstEntry());
            retVal.append('\u00a0');
            retVal.append("Last:");
            retVal.append(this.lastEntry());
            retVal.append('\u00a0');
            retVal.append("Size:");
            retVal.append(this.size());
        }
    }

    void setColour(Colour aPaint) {
        this.colour(aPaint);
    }

    void setName(String aName) {
        this.name(aName);
    }

    StringBuilder toStringFirstPart() {
        StringBuilder retVal = new StringBuilder();
        if (this.getName() != null) {
            retVal.append(this.getName());
            retVal.append('\u00a0');
        }
        return retVal;
    }
}

