/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.StandardType;

public final class CalendarDate
implements Comparable<CalendarDate> {
    static final int NANOS_PER_SECOND = 1000000000;
    static final long SECONDS_PER_DAY = 86400L;
    public final long millis;

    public static CalendarDate make(Calendar aCalendar, CalendarDateUnit resolution) {
        return new CalendarDate(resolution.toTimeInMillis(aCalendar));
    }

    public static CalendarDate make(CalendarDateUnit resolution) {
        return new CalendarDate(resolution.toTimeInMillis(System.currentTimeMillis()));
    }

    public static CalendarDate make(Date aDate, CalendarDateUnit resolution) {
        return new CalendarDate(resolution.toTimeInMillis(aDate));
    }

    public static CalendarDate make(long aTimeInMIllis, CalendarDateUnit resolution) {
        return new CalendarDate(resolution.toTimeInMillis(aTimeInMIllis));
    }

    public CalendarDate() {
        this.millis = System.currentTimeMillis();
    }

    public CalendarDate(Calendar aCalendar) {
        this.millis = aCalendar.getTimeInMillis();
    }

    public CalendarDate(Date aDate) {
        this.millis = aDate.getTime();
    }

    public CalendarDate(long timeInMillis) {
        this.millis = timeInMillis;
    }

    public CalendarDate(String anSqlString) {
        boolean tmpTimePart;
        boolean tmpDatePart = anSqlString.indexOf(45) >= 0;
        boolean bl = tmpTimePart = anSqlString.indexOf(58) >= 0;
        this.millis = tmpDatePart && tmpTimePart ? ((Date)StandardType.SQL_DATETIME.parse(anSqlString)).getTime() : (tmpDatePart && !tmpTimePart ? ((Date)StandardType.SQL_DATE.parse(anSqlString)).getTime() : (!tmpDatePart && tmpTimePart ? ((Date)StandardType.SQL_TIME.parse(anSqlString)).getTime() : 0L));
    }

    @Override
    public int compareTo(CalendarDate ref) {
        return Long.signum(this.millis - ref.millis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarDate)) {
            return false;
        }
        CalendarDate other = (CalendarDate)obj;
        return this.millis == other.millis;
    }

    public CalendarDate filter(CalendarDateUnit resolution) {
        if (resolution.isCalendarUnit()) {
            return new CalendarDate(resolution.toTimeInMillis(this.getCalendar()));
        }
        return new CalendarDate(resolution.toTimeInMillis(this.millis));
    }

    public Calendar getCalendar() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar getCalendar(Locale aLocale) {
        GregorianCalendar retVal = new GregorianCalendar(aLocale);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar getCalendar(TimeZone aTimeZone) {
        GregorianCalendar retVal = new GregorianCalendar(aTimeZone);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Calendar getCalendar(TimeZone aTimeZone, Locale aLocale) {
        GregorianCalendar retVal = new GregorianCalendar(aTimeZone, aLocale);
        retVal.setTimeInMillis(this.millis);
        return retVal;
    }

    public Date getDate() {
        return new Date(this.millis);
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >>> 32);
    }

    public CalendarDate step(CalendarDateDuration aStepDuration) {
        return this.step((int)aStepDuration.measure, aStepDuration.unit);
    }

    public CalendarDate step(CalendarDateUnit aStepUnit) {
        return this.step(1, aStepUnit);
    }

    public CalendarDate step(int aStepCount, CalendarDateUnit aStepUnit) {
        if (aStepUnit.isCalendarUnit()) {
            return new CalendarDate(aStepUnit.step(this.getCalendar(), aStepCount));
        }
        return new CalendarDate(aStepUnit.step(this.millis, aStepCount));
    }

    public LocalDateTime toDateAndTime() {
        return this.toDateAndTime(ZoneOffset.UTC);
    }

    public LocalDateTime toDateAndTime(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        int tmpNanos = (int)Math.floorMod(this.millis, 1000L);
        return LocalDateTime.ofEpochSecond(tmpSeconds, tmpNanos, offset);
    }

    public LocalDate toDateOnly() {
        return this.toDateOnly(ZoneOffset.UTC);
    }

    public LocalDate toDateOnly(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        long tmpLocalSeconds = tmpSeconds + (long)offset.getTotalSeconds();
        long tmpLocalDay = Math.floorDiv(tmpLocalSeconds, 86400L);
        return LocalDate.ofEpochDay(tmpLocalDay);
    }

    @Deprecated
    public Date toSqlDate() {
        LocalDate tmpDateOnly = this.toDateOnly();
        return new Date(tmpDateOnly.getYear() - 1970, tmpDateOnly.getMonthValue() - 1, tmpDateOnly.getDayOfMonth());
    }

    @Deprecated
    public Date toSqlTime() {
        LocalTime tmpTimeOnly = this.toTimeOnly();
        return new Date(70, 0, 1, tmpTimeOnly.getHour(), tmpTimeOnly.getMinute(), tmpTimeOnly.getSecond());
    }

    @Deprecated
    public Date toSqlTimestamp() {
        return new Date(this.millis);
    }

    public String toString() {
        return StandardType.SQL_DATETIME.format(this.getDate());
    }

    public long toTimeInMillis(CalendarDateUnit resolution) {
        if (resolution.isCalendarUnit()) {
            return resolution.toTimeInMillis(this.getCalendar());
        }
        return resolution.toTimeInMillis(this.millis);
    }

    public LocalTime toTimeOnly() {
        return this.toTimeOnly(ZoneOffset.UTC);
    }

    public LocalTime toTimeOnly(ZoneOffset offset) {
        long tmpSeconds = Math.floorDiv(this.millis, 1000L);
        int tmpNanos = (int)Math.floorMod(this.millis, 1000L);
        long tmpLocalSeconds = tmpSeconds + (long)offset.getTotalSeconds();
        int tmpSecondOfDay = (int)Math.floorMod(tmpLocalSeconds, 86400L);
        int tmpNanoOfDay = tmpSecondOfDay * 1000000000 + tmpNanos;
        return LocalTime.ofNanoOfDay(tmpNanoOfDay);
    }
}

