/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import java.util.Random;
import org.jblas.DoubleMatrix;
import xlinear.DenseMatrix;
import xlinear.SparseMatrix;
import xlinear.StaticUtils;
import xlinear.internals.MatrixVisitorEditInPlace;

public class MatrixOperations {
    public static DenseMatrix dense(int nRows, int nCols) {
        return StaticUtils.createEmptyDenseMatrix(nRows, nCols);
    }

    public static SparseMatrix sparse(int nRows, int nCols) {
        return StaticUtils.createEmptySparseMatrix(nRows, nCols);
    }

    public static DenseMatrix dense(int nRows) {
        return StaticUtils.createEmptyDenseMatrix(nRows, 1);
    }

    public static SparseMatrix sparse(int nRows) {
        return StaticUtils.createEmptySparseMatrix(nRows, 1);
    }

    public static SparseMatrix identity(int size) {
        return StaticUtils.identity(size);
    }

    public static DenseMatrix ones(int rows, int cols) {
        DenseMatrix result = MatrixOperations.dense(rows, cols);
        MatrixVisitorEditInPlace _function = ($0, $1, $2) -> 1.0;
        result.editInPlace(_function);
        return result;
    }

    public static DenseMatrix ones(int size) {
        return MatrixOperations.ones(size, 1);
    }

    public static DenseMatrix denseCopy(double[][] data) {
        return StaticUtils.createDenseMatrixByCopyingArrayContents(data);
    }

    public static DenseMatrix denseCopy(double[] data) {
        return StaticUtils.createDenseMatrixByCopyingArrayContents(data);
    }

    public static DenseMatrix denseCopy(DoubleMatrix jblasMatrix) {
        DenseMatrix result = MatrixOperations.dense(jblasMatrix.rows, jblasMatrix.columns);
        MatrixVisitorEditInPlace _function = (row, col, zero) -> jblasMatrix.get(row, col);
        result.editInPlace(_function);
        return result;
    }

    public static SparseMatrix sparseCopy(double[][] data) {
        return StaticUtils.createSparseMatrixByCopyingArrayContents(data);
    }

    public static SparseMatrix sparseCopy(double[] data) {
        return StaticUtils.createSparseMatrixByCopyingArrayContents(data);
    }

    public static DenseMatrix standardNormalVector(Random random, int dim) {
        DenseMatrix result = MatrixOperations.dense(dim);
        for (int i = 0; i < dim; ++i) {
            double _nextGaussian = random.nextGaussian();
            result.set(i, _nextGaussian);
        }
        return result;
    }

    private MatrixOperations() {
    }
}

