/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import java.util.ArrayList;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import xlinear.CholeskyDecomposition;
import xlinear.DenseMatrix;
import xlinear.Matrix;
import xlinear.StaticUtils;
import xlinear.internals.ColtSparseMatrix;
import xlinear.internals.MatrixVisitorEditInPlace;
import xlinear.internals.MatrixVisitorViewOnly;

public interface SparseMatrix
extends Matrix {
    public void visitNonZeros(MatrixVisitorViewOnly var1);

    public void editNonZerosInPlace(MatrixVisitorEditInPlace var1);

    @Override
    public SparseMatrix createEmpty(int var1, int var2);

    @Override
    default public CholeskyDecomposition cholesky() {
        ColtSparseMatrix _convertToColtSparseMatrix = StaticUtils.convertToColtSparseMatrix(this);
        return _convertToColtSparseMatrix.cholesky();
    }

    @Override
    default public Matrix inverse() {
        throw new UnsupportedOperationException("Inverting a sparse matrix does not exploit sparsity.\nCopy to dense matrix if this is really what you intend to do.");
    }

    @Override
    default public DoubleStream nonZeroEntries() {
        ArrayList values = new ArrayList();
        MatrixVisitorViewOnly _function = (row, col, value) -> values.add(value);
        this.visitNonZeros(_function);
        Stream _stream = values.stream();
        ToDoubleFunction<Double> _function_1 = it -> it;
        return _stream.mapToDouble(_function_1);
    }

    @Override
    default public SparseMatrix transpose() {
        int _nCols = this.nCols();
        int _nRows = this.nRows();
        SparseMatrix result = this.createEmpty(_nCols, _nRows);
        MatrixVisitorViewOnly _function = (row, col, value) -> result.set(col, row, value);
        this.visitNonZeros(_function);
        return result;
    }

    @Override
    default public SparseMatrix operator_multiply(Number n) {
        return this.mul(n);
    }

    @Override
    default public SparseMatrix mul(Number n) {
        double _doubleValue = n.doubleValue();
        return StaticUtils.scale(this, _doubleValue);
    }

    @Override
    default public void mulInPlace(Number n) {
        double _doubleValue = n.doubleValue();
        StaticUtils.scaleInPlace(this, _doubleValue);
    }

    @Override
    default public Matrix operator_multiply(Matrix m) {
        return this.mul(m);
    }

    @Override
    default public DenseMatrix operator_multiply(DenseMatrix m) {
        return this.mul(m);
    }

    @Override
    default public SparseMatrix operator_multiply(SparseMatrix m) {
        return this.mul(m);
    }

    @Override
    default public DenseMatrix mul(DenseMatrix m) {
        return StaticUtils.multiply(this, m);
    }

    @Override
    public SparseMatrix mul(SparseMatrix var1);

    @Override
    default public Matrix operator_plus(Matrix m) {
        return this.add(m);
    }

    @Override
    default public DenseMatrix operator_plus(DenseMatrix m) {
        return this.add(m);
    }

    @Override
    default public SparseMatrix operator_plus(SparseMatrix m) {
        return this.add(m);
    }

    @Override
    default public DenseMatrix add(DenseMatrix m) {
        return StaticUtils.add(this, m);
    }

    @Override
    default public SparseMatrix add(SparseMatrix m) {
        return StaticUtils.add(this, m);
    }

    @Override
    default public void addInPlace(DenseMatrix m) {
        StaticUtils.addInPlace(this, m);
    }

    @Override
    default public void addInPlace(SparseMatrix m) {
        StaticUtils.addInPlace((Matrix)this, m);
    }

    @Override
    default public Matrix operator_minus(Matrix m) {
        return this.sub(m);
    }

    @Override
    default public DenseMatrix operator_minus(DenseMatrix m) {
        return this.sub(m);
    }

    @Override
    default public SparseMatrix operator_minus(SparseMatrix m) {
        return this.sub(m);
    }

    @Override
    default public DenseMatrix sub(DenseMatrix m) {
        return StaticUtils.subtract(this, m);
    }

    @Override
    default public SparseMatrix sub(SparseMatrix m) {
        return StaticUtils.subtract(this, m);
    }

    @Override
    default public void subInPlace(DenseMatrix m) {
        StaticUtils.subtractInPlace(this, m);
    }

    @Override
    default public void subInPlace(SparseMatrix m) {
        StaticUtils.subtractInPlace(this, m);
    }

    @Override
    public SparseMatrix slice(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    default public SparseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl) {
        Matrix _slice = Matrix.super.slice(row0Incl, row1Excl, col0Incl, col1Excl);
        return (SparseMatrix)_slice;
    }

    @Override
    default public SparseMatrix row(int index) {
        Matrix _row = Matrix.super.row(index);
        return (SparseMatrix)_row;
    }

    @Override
    default public SparseMatrix col(int index) {
        Matrix _col = Matrix.super.col(index);
        return (SparseMatrix)_col;
    }

    @Override
    default public SparseMatrix readOnlyView() {
        Matrix _readOnlyView = Matrix.super.readOnlyView();
        return (SparseMatrix)_readOnlyView;
    }
}

