/*
 * Decompiled with CFR 0.152.
 */
package xlinear.internals;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import xlinear.CholeskyDecomposition;
import xlinear.Matrix;
import xlinear.SparseMatrix;
import xlinear.StaticUtils;
import xlinear.internals.MatrixVisitorEditInPlace;
import xlinear.internals.MatrixVisitorViewOnly;
import xlinear.internals.Slice;

@Data
public class ColtSparseMatrix
implements SparseMatrix {
    private final DoubleMatrix2D implementation;

    @Override
    public void visitNonZeros(MatrixVisitorViewOnly visitor) {
        IntIntDoubleFunction _function = (row, col, value) -> {
            visitor.visit(row, col, value);
            return value;
        };
        this.implementation.forEachNonZero(_function);
    }

    @Override
    public void editNonZerosInPlace(MatrixVisitorEditInPlace visitor) {
        IntIntDoubleFunction _function = (row, col, value) -> visitor.editInPlace(row, col, value);
        this.implementation.forEachNonZero(_function);
    }

    @Override
    public ColtSparseMatrix createEmpty(int nRows, int nCols) {
        SparseDoubleMatrix2D _sparseDoubleMatrix2D = new SparseDoubleMatrix2D(nRows, nCols);
        return new ColtSparseMatrix((DoubleMatrix2D)_sparseDoubleMatrix2D);
    }

    @Override
    public SparseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean readOnly) {
        StaticUtils.checkValidSlice(this, row0Incl, row1Excl, col0Incl, col1Excl);
        return new ColtSparseMatrixSlice(this, row0Incl, row1Excl, col0Incl, col1Excl, readOnly);
    }

    @Override
    public ColtSparseMatrix mul(SparseMatrix another) {
        StaticUtils.checkMatrixMultiplicationDimensionsMatch(this, another);
        boolean _matched = false;
        if (!_matched && another instanceof ColtSparseMatrix) {
            _matched = true;
            int _nRows = this.nRows();
            int _nCols = ((ColtSparseMatrix)another).nCols();
            ColtSparseMatrix result = this.createEmpty(_nRows, _nCols);
            this.implementation.zMult(((ColtSparseMatrix)another).implementation, result.implementation);
            return result;
        }
        ColtSparseMatrix _convertToColtSparseMatrix = StaticUtils.convertToColtSparseMatrix(another);
        return this.mul(_convertToColtSparseMatrix);
    }

    @Override
    public CholeskyDecomposition cholesky() {
        DoubleMatrix2D implementation = this.implementation;
        boolean _matched = false;
        if (!_matched && implementation instanceof SparseDoubleMatrix2D) {
            _matched = true;
            SparseCCDoubleMatrix2D _columnCompressed = ((SparseDoubleMatrix2D)this.implementation).getColumnCompressed(false);
            SparseDoubleCholeskyDecomposition chol = new SparseDoubleCholeskyDecomposition((DoubleMatrix2D)_columnCompressed, 0);
            DoubleMatrix2D _l = chol.getL();
            ColtSparseMatrix L = new ColtSparseMatrix(_l);
            SparseMatrix _readOnlyView = L.readOnlyView();
            return new CholeskyDecomposition(_readOnlyView);
        }
        ColtSparseMatrix _convertToColtSparseMatrix = StaticUtils.convertToColtSparseMatrix(this);
        return _convertToColtSparseMatrix.cholesky();
    }

    @Override
    public int nRows() {
        return this.implementation.rows();
    }

    @Override
    public int nCols() {
        return this.implementation.columns();
    }

    @Override
    public double get(int row, int col) {
        double _xblockexpression = 0.0;
        StaticUtils.checkBounds(this, row, col);
        _xblockexpression = this.implementation.get(row, col);
        return _xblockexpression;
    }

    @Override
    public void set(int row, int col, double v) {
        StaticUtils.checkBounds(this, row, col);
        this.implementation.set(row, col, v);
    }

    public String toString() {
        String _stringDimensions = StaticUtils.toStringDimensions(this);
        String _plus = _stringDimensions + " sparse matrix\n";
        String _string = StaticUtils.toString(this);
        return _plus + _string;
    }

    public ColtSparseMatrix(DoubleMatrix2D implementation) {
        this.implementation = implementation;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.implementation == null ? 0 : this.implementation.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColtSparseMatrix other = (ColtSparseMatrix)obj;
        return !(this.implementation == null ? other.implementation != null : !this.implementation.equals((Object)other.implementation));
    }

    @Pure
    public DoubleMatrix2D getImplementation() {
        return this.implementation;
    }

    private static class ColtSparseMatrixSlice
    extends Slice
    implements SparseMatrix {
        private ColtSparseMatrix root() {
            return (ColtSparseMatrix)this.rootMatrix;
        }

        public ColtSparseMatrixSlice(ColtSparseMatrix rootMatrix, int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean readOnly) {
            super(rootMatrix, row0Incl, row1Excl, col0Incl, col1Excl, readOnly);
        }

        @Override
        public SparseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Incl, boolean subSliceReadOnly) {
            Matrix _slice = super.slice(row0Incl, row1Excl, col0Incl, col1Incl, subSliceReadOnly);
            return (SparseMatrix)_slice;
        }

        @Override
        public void visitNonZeros(MatrixVisitorViewOnly visitor) {
            ColtSparseMatrix _root;
            int _cardinality;
            boolean _lessThan;
            int _nCols;
            int _nRows = this.nRows();
            int _multiply = _nRows * (_nCols = this.nCols());
            boolean bl = _lessThan = _multiply < (_cardinality = (_root = this.root()).implementation.cardinality());
            if (_lessThan) {
                for (int row2 = 0; row2 < this.nRows(); ++row2) {
                    for (int col2 = 0; col2 < this.nCols(); ++col2) {
                        double value2 = this.get(row2, col2);
                        if (value2 == 0.0) continue;
                        visitor.visit(row2, col2, value2);
                    }
                }
            } else {
                ColtSparseMatrix _root_1 = this.root();
                MatrixVisitorViewOnly _function = (row, col, value) -> {
                    if (row >= this.row0Incl && row < this.row1Excl && col >= this.col0Incl && col < this.col1Excl) {
                        int _rowRoot2Slice = this.rowRoot2Slice(row);
                        int _colRoot2Slice = this.colRoot2Slice(col);
                        visitor.visit(_rowRoot2Slice, _colRoot2Slice, value);
                    }
                };
                _root_1.visitNonZeros(_function);
            }
        }

        @Override
        public void editNonZerosInPlace(MatrixVisitorEditInPlace visitor) {
            ColtSparseMatrix _root;
            int _cardinality;
            boolean _lessThan;
            int _nCols;
            if (this.readOnly) {
                throw new UnsupportedOperationException();
            }
            int _nRows = this.nRows();
            int _multiply = _nRows * (_nCols = this.nCols());
            boolean bl = _lessThan = _multiply < (_cardinality = (_root = this.root()).implementation.cardinality());
            if (_lessThan) {
                for (int row2 = 0; row2 < this.nRows(); ++row2) {
                    for (int col2 = 0; col2 < this.nCols(); ++col2) {
                        double value2 = this.get(row2, col2);
                        if (value2 == 0.0) continue;
                        double _editInPlace = visitor.editInPlace(row2, col2, value2);
                        this.set(row2, col2, _editInPlace);
                    }
                }
            } else {
                ColtSparseMatrix _root_1 = this.root();
                MatrixVisitorEditInPlace _function = (row, col, value) -> {
                    if (row >= this.row0Incl && row < this.row1Excl && col >= this.col0Incl && col < this.col1Excl) {
                        int _rowRoot2Slice = this.rowRoot2Slice(row);
                        int _colRoot2Slice = this.colRoot2Slice(col);
                        return visitor.editInPlace(_rowRoot2Slice, _colRoot2Slice, value);
                    }
                    return value;
                };
                _root_1.editNonZerosInPlace(_function);
            }
        }

        @Override
        public SparseMatrix createEmpty(int nRows, int nCols) {
            ColtSparseMatrix _root = this.root();
            return _root.createEmpty(nRows, nCols);
        }

        @Override
        public SparseMatrix mul(SparseMatrix another) {
            SparseMatrix copy = StaticUtils.copy(this);
            return copy.mul(another);
        }

        @Override
        public String toString() {
            String _stringDimensions = StaticUtils.toStringDimensions(this);
            String _plus = _stringDimensions + " sparse matrix";
            String _xifexpression = null;
            _xifexpression = this.readOnly ? " read-only" : "";
            String _plus_1 = _plus + _xifexpression;
            String _plus_2 = _plus_1 + " slice\n";
            String _string = StaticUtils.toString(this);
            return _plus_2 + _string;
        }
    }
}

