/*
 * Decompiled with CFR 0.152.
 */
package xlinear.internals;

import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import xlinear.CholeskyDecomposition;
import xlinear.DenseMatrix;
import xlinear.Matrix;
import xlinear.StaticUtils;
import xlinear.internals.MatrixVisitorEditInPlace;
import xlinear.internals.MatrixVisitorViewOnly;
import xlinear.internals.Slice;

@Data
public class CommonsDenseMatrix
implements DenseMatrix {
    private final RealMatrix implementation;

    @Override
    public void visit(final MatrixVisitorViewOnly visitor) {
        this.implementation.walkInOptimizedOrder(new RealMatrixPreservingVisitor(){

            public double end() {
                return 0.0;
            }

            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            }

            public void visit(int row, int column, double value) {
                visitor.visit(row, column, value);
            }
        });
    }

    @Override
    public void editInPlace(final MatrixVisitorEditInPlace visitor) {
        this.implementation.walkInOptimizedOrder(new RealMatrixChangingVisitor(){

            public double end() {
                return 0.0;
            }

            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            }

            public double visit(int row, int column, double value) {
                return visitor.editInPlace(row, column, value);
            }
        });
    }

    @Override
    public CommonsDenseMatrix mul(DenseMatrix another) {
        StaticUtils.checkMatrixMultiplicationDimensionsMatch(this, another);
        boolean _matched = false;
        if (!_matched && another instanceof CommonsDenseMatrix) {
            _matched = true;
            RealMatrix _multiply = this.implementation.multiply(((CommonsDenseMatrix)another).implementation);
            return new CommonsDenseMatrix(_multiply);
        }
        CommonsDenseMatrix _convertToCommonsDenseMatrix = StaticUtils.convertToCommonsDenseMatrix(another);
        return this.mul(_convertToCommonsDenseMatrix);
    }

    @Override
    public CholeskyDecomposition cholesky() {
        org.apache.commons.math3.linear.CholeskyDecomposition chol = new org.apache.commons.math3.linear.CholeskyDecomposition(this.implementation);
        RealMatrix _l = chol.getL();
        CommonsDenseMatrix L = new CommonsDenseMatrix(_l);
        DenseMatrix _readOnlyView = L.readOnlyView();
        return new CholeskyDecomposition(_readOnlyView);
    }

    @Override
    public CommonsDenseMatrix inverse() {
        LUDecomposition _lUDecomposition = new LUDecomposition(this.implementation);
        DecompositionSolver _solver = _lUDecomposition.getSolver();
        RealMatrix inverted = _solver.getInverse();
        return new CommonsDenseMatrix(inverted);
    }

    @Override
    public CommonsDenseMatrix createEmpty(int nRows, int nCols) {
        BlockRealMatrix _blockRealMatrix = new BlockRealMatrix(nRows, nCols);
        return new CommonsDenseMatrix((RealMatrix)_blockRealMatrix);
    }

    @Override
    public DenseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean readOnly) {
        StaticUtils.checkValidSlice(this, row0Incl, row1Excl, col0Incl, col1Excl);
        return new CommonsDenseMatrixSlice(this, row0Incl, row1Excl, col0Incl, col1Excl, readOnly);
    }

    @Override
    public int nRows() {
        return this.implementation.getRowDimension();
    }

    @Override
    public int nCols() {
        return this.implementation.getColumnDimension();
    }

    @Override
    public double get(int row, int col) {
        return this.implementation.getEntry(row, col);
    }

    @Override
    public void set(int row, int col, double v) {
        this.implementation.setEntry(row, col, v);
    }

    public String toString() {
        String _stringDimensions = StaticUtils.toStringDimensions(this);
        String _plus = _stringDimensions + " dense matrix\n";
        String _string = StaticUtils.toString(this);
        return _plus + _string;
    }

    public CommonsDenseMatrix(RealMatrix implementation) {
        this.implementation = implementation;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.implementation == null ? 0 : this.implementation.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonsDenseMatrix other = (CommonsDenseMatrix)obj;
        return !(this.implementation == null ? other.implementation != null : !this.implementation.equals(other.implementation));
    }

    @Pure
    public RealMatrix getImplementation() {
        return this.implementation;
    }

    private static class CommonsDenseMatrixSlice
    extends Slice
    implements DenseMatrix {
        private CommonsDenseMatrix root() {
            return (CommonsDenseMatrix)this.rootMatrix;
        }

        public CommonsDenseMatrixSlice(CommonsDenseMatrix rootMatrix, int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean readOnly) {
            super(rootMatrix, row0Incl, row1Excl, col0Incl, col1Excl, readOnly);
        }

        @Override
        public DenseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Incl, boolean subSliceReadOnly) {
            Matrix _slice = super.slice(row0Incl, row1Excl, col0Incl, col1Incl, subSliceReadOnly);
            return (DenseMatrix)_slice;
        }

        @Override
        public void visit(final MatrixVisitorViewOnly visitor) {
            CommonsDenseMatrix _root = this.root();
            _root.implementation.walkInOptimizedOrder(new RealMatrixPreservingVisitor(){

                public double end() {
                    return 0.0;
                }

                public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                }

                public void visit(int row, int col, double value) {
                    int _rowRoot2Slice = this.rowRoot2Slice(row);
                    int _colRoot2Slice = this.colRoot2Slice(col);
                    visitor.visit(_rowRoot2Slice, _colRoot2Slice, value);
                }
            }, this.row0Incl, this.row1Excl - 1, this.col0Incl, this.col1Excl - 1);
        }

        @Override
        public void editInPlace(final MatrixVisitorEditInPlace visitor) {
            if (this.readOnly) {
                throw new UnsupportedOperationException();
            }
            CommonsDenseMatrix _root = this.root();
            _root.implementation.walkInOptimizedOrder(new RealMatrixChangingVisitor(){

                public double end() {
                    return 0.0;
                }

                public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                }

                public double visit(int row, int col, double value) {
                    int _rowRoot2Slice = this.rowRoot2Slice(row);
                    int _colRoot2Slice = this.colRoot2Slice(col);
                    return visitor.editInPlace(_rowRoot2Slice, _colRoot2Slice, value);
                }
            }, this.row0Incl, this.row1Excl - 1, this.col0Incl, this.col1Excl - 1);
        }

        @Override
        public DenseMatrix createEmpty(int nRows, int nCols) {
            CommonsDenseMatrix _root = this.root();
            return _root.createEmpty(nRows, nCols);
        }

        @Override
        public DenseMatrix mul(DenseMatrix another) {
            DenseMatrix copy = StaticUtils.copy(this);
            return copy.mul(another);
        }

        @Override
        public String toString() {
            String _stringDimensions = StaticUtils.toStringDimensions(this);
            String _plus = _stringDimensions + " dense matrix";
            String _xifexpression = null;
            _xifexpression = this.readOnly ? " read-only" : "";
            String _plus_1 = _plus + _xifexpression;
            String _plus_2 = _plus_1 + " slice\n";
            String _string = StaticUtils.toString(this);
            return _plus_2 + _string;
        }
    }
}

