/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.benchmark;

import org.jblas.DoubleMatrix;
import org.jblas.benchmark.Benchmark;
import org.jblas.benchmark.BenchmarkResult;
import org.jblas.benchmark.Timer;

class NativeDoubleMultiplicationBenchmark
implements Benchmark {
    NativeDoubleMultiplicationBenchmark() {
    }

    public String getName() {
        return "native matrix multiplication, double precision";
    }

    public BenchmarkResult run(int size, double seconds) {
        int counter = 0;
        long ops = 0L;
        DoubleMatrix A = DoubleMatrix.randn(size, size);
        DoubleMatrix B = DoubleMatrix.randn(size, size);
        DoubleMatrix C = DoubleMatrix.randn(size, size);
        Timer t = new Timer();
        t.start();
        while (!t.ranFor(seconds)) {
            A.mmuli(B, C);
            ++counter;
            ops += 2L * (long)size * (long)size * (long)size;
        }
        t.stop();
        return new BenchmarkResult(ops, t.elapsedSeconds(), counter);
    }
}

