/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tobject;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.function.tobject.LongObjectProcedure;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractLongObjectMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractLongObjectMap() {
    }

    public boolean containsKey(final long key) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final Object value) {
        return !this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractLongObjectMap copy() {
        return (AbstractLongObjectMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongObjectMap)) {
            return false;
        }
        final AbstractLongObjectMap other = (AbstractLongObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new LongObjectProcedure(){

            public boolean apply(long key, Object value) {
                return AbstractLongObjectMap.this.containsKey(key) && AbstractLongObjectMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongObjectProcedure procedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                return procedure.apply(key, AbstractLongObjectMap.this.get(key));
            }
        });
    }

    public abstract Object get(long var1);

    public long keyOf(final Object value) {
        final long[] foundKey = new long[1];
        boolean notFound = this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long iterKey, Object iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Long.MIN_VALUE;
        }
        return foundKey[0];
    }

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList keyList) {
        this.pairsSortedByValue(keyList, new ObjectArrayList(this.size()));
    }

    public void pairsMatching(final LongObjectProcedure condition, final LongArrayList keyList, final ObjectArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new LongObjectProcedure(){

            public boolean apply(long key, Object value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList keyList, ObjectArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(LongArrayList keyList, ObjectArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] k = keyList.elements();
        final Object[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                Object t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                long t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                int ab = ((Comparable)v[a]).compareTo(v[b]);
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(long var1, Object var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        LongArrayList theKeys = new LongArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public ObjectArrayList values() {
        ObjectArrayList list = new ObjectArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ObjectArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long key) {
                list.add(AbstractLongObjectMap.this.get(key));
                return true;
            }
        });
    }
}

