/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.algo.decomposition.SparseDComplexCholeskyDecomposition;
import cern.colt.matrix.tdcomplex.algo.decomposition.SparseDComplexLUDecomposition;
import cern.colt.matrix.tdcomplex.algo.decomposition.SparseDComplexQRDecomposition;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_norm;

public class SparseDComplexAlgebra {
    public static final SparseDComplexAlgebra DEFAULT = new SparseDComplexAlgebra();
    public static final SparseDComplexAlgebra ZERO;
    protected DComplexProperty property;

    private static double normInfinityRC(SparseRCDComplexMatrix2D A) {
        double norm = 0.0;
        int n = A.rows();
        int[] Ap = A.getRowPointers();
        double[] Ax = A.getValues();
        for (int j = 0; j < n; ++j) {
            double s = 0.0;
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                s += Math.abs(Ax[p]);
            }
            norm = Math.max(norm, s);
        }
        return norm;
    }

    public SparseDComplexAlgebra() {
        this(DComplexProperty.DEFAULT.tolerance());
    }

    public SparseDComplexAlgebra(double tolerance) {
        this.setProperty(new DComplexProperty(tolerance));
    }

    public SparseDComplexCholeskyDecomposition chol(DComplexMatrix2D matrix, int order) {
        return new SparseDComplexCholeskyDecomposition(matrix, order);
    }

    public Object clone() {
        return new SparseDComplexAlgebra(this.property.tolerance());
    }

    public double[] det(DComplexMatrix2D A) {
        return this.lu(A, 0).det();
    }

    public SparseDComplexLUDecomposition lu(DComplexMatrix2D matrix, int order) {
        return new SparseDComplexLUDecomposition(matrix, order, true);
    }

    public double norm1(DComplexMatrix2D A) {
        DComplexProperty.DEFAULT.checkSparse(A);
        double norm = A instanceof SparseCCDComplexMatrix2D ? DZcs_norm.cs_norm((DZcs_common.DZcs)((DZcs_common.DZcs)A.elements())) : DZcs_norm.cs_norm((DZcs_common.DZcs)((SparseRCDComplexMatrix2D)A).getColumnCompressed().elements());
        return norm;
    }

    public double normInfinity(DComplexMatrix2D A) {
        DComplexProperty.DEFAULT.checkSparse(A);
        double norm = A instanceof SparseRCDComplexMatrix2D ? SparseDComplexAlgebra.normInfinityRC((SparseRCDComplexMatrix2D)A) : SparseDComplexAlgebra.normInfinityRC(((SparseCCDComplexMatrix2D)A).getRowCompressed());
        return norm;
    }

    public DComplexProperty property() {
        return this.property;
    }

    public SparseDComplexQRDecomposition qr(DComplexMatrix2D matrix, int order) {
        return new SparseDComplexQRDecomposition(matrix, order);
    }

    public void setProperty(DComplexProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public DComplexMatrix1D solve(DComplexMatrix2D A, DComplexMatrix1D b) {
        DenseDComplexMatrix1D x = new DenseDComplexMatrix1D(Math.max(A.rows(), A.columns()));
        x.viewPart(0, (int)b.size()).assign(b);
        if (A.rows() == A.columns()) {
            this.lu(A, 0).solve(x);
            return x;
        }
        this.qr(A, 0).solve(x);
        return x.viewPart(0, A.columns()).copy();
    }

    static {
        SparseDComplexAlgebra.DEFAULT.property = DComplexProperty.DEFAULT;
        ZERO = new SparseDComplexAlgebra();
        SparseDComplexAlgebra.ZERO.property = DComplexProperty.ZERO;
    }
}

