/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix3D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix3D.txt";
    private static double[][][] a_3d;
    private static double[][][] b_3d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix3D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int c;
        int r;
        int s;
        BenchmarkMatrixKernel.readSettings3D();
        Random rand = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        a_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        a_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        int idx = 0;
        for (s = 0; s < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++s) {
            for (r = 0; r < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++r) {
                for (c = 0; c < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++c) {
                    BenchmarkDenseDComplexMatrix3D.a_3d[s][r][c] = rand.nextDouble();
                    BenchmarkDenseDComplexMatrix3D.a_1d[idx++] = a_3d[s][r][c];
                }
            }
        }
        b_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        b_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        idx = 0;
        for (s = 0; s < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++s) {
            for (r = 0; r < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++r) {
                for (c = 0; c < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++c) {
                    BenchmarkDenseDComplexMatrix3D.b_3d[s][r][c] = rand.nextDouble();
                    BenchmarkDenseDComplexMatrix3D.b_1d[idx++] = b_3d[s][r][c];
                }
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_3D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_3D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_3d = null;
        b_1d = null;
        b_3d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix3D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix3D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix3DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        DenseDComplexMatrix3D B = new DenseDComplexMatrix3D(b_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix3D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix3D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DComplexMatrix3D Bv = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexMatrix3D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        double value = Math.random();
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(value, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(value, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(a_1d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(a_1d);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a_1d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a_1d);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArrayArray() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(a_3d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(a_3d);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a_3d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a_3d);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double[][][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(DComplexFunctions.acos);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                Av.assign(DComplexFunctions.acos);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix3D() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DenseDComplexMatrix3D B = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(B);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(B);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DComplexMatrix3D Av = A.viewDice(2, 1, 0);
        B = new DenseDComplexMatrix3D(a_3d);
        DComplexMatrix3D Bv = B.viewDice(2, 1, 0);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(Bv);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix3D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix3DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        DenseDComplexMatrix3D B = new DenseDComplexMatrix3D(b_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(B, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(B, DComplexFunctions.div);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DComplexMatrix3D Bv = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                Av.assign(Bv, DComplexFunctions.div);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix3D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        double[] value = new double[]{-1.0, -2.0};
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(procedure, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                Av.assign(procedure, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix3D)A).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)A).assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                Av.assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            int card = ((DComplexMatrix3D)A).cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = ((DComplexMatrix3D)A).cardinality();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix3D(a_3d);
        DComplexMatrix3D Av = A.viewDice(2, 1, 0);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            int card = Av.cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = Av.cardinality();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft3() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.fft3();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_3d);
                t.reset().start();
                A.fft3();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix3D)Av).fft3();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)Av).fft3();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fft3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2Slices() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.fft2Slices();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_3d);
                t.reset().start();
                A.fft2Slices();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix3D)Av).fft2Slices();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)Av).fft2Slices();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fft2Slices()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix3D B = ((DComplexMatrix3D)A).getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix3D)A).getRealPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix3D Bv = Av.getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Bv = Av.getRealPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix3D B = ((DComplexMatrix3D)A).getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix3D)A).getImaginaryPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix3D Bv = Av.getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Bv = Av.getImaginaryPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListIntArrayListArrayList() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        IntArrayList sliceList = new IntArrayList();
        IntArrayList rowList = new IntArrayList();
        IntArrayList colList = new IntArrayList();
        ArrayList<double[]> valueList = new ArrayList<double[]>();
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix3D)A).getNonZeros(sliceList, rowList, colList, valueList);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                sliceList.clear();
                rowList.clear();
                colList.clear();
                valueList.clear();
                t.reset().start();
                ((DComplexMatrix3D)A).getNonZeros(sliceList, rowList, colList, valueList);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(a_3d).viewDice(2, 1, 0);
        sliceList.clear();
        rowList.clear();
        colList.clear();
        valueList.clear();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.getNonZeros(sliceList, rowList, colList, valueList);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                sliceList.clear();
                rowList.clear();
                colList.clear();
                valueList.clear();
                t.reset().start();
                Av.getNonZeros(sliceList, rowList, colList, valueList);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getNonZeros(IntArrayList, IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft3() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.ifft3(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_3d);
                t.reset().start();
                A.ifft3(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix3D)Av).ifft3(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)Av).ifft3(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifft3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2Slices() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.ifft2Slices(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_3d);
                t.reset().start();
                A.ifft2Slices(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix3D)Av).ifft2Slices(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)Av).ifft2Slices(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifft2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix3D)A).zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix3D)A).zSum();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.zSum();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[][][] array = ((DComplexMatrix3D)A).toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = ((DComplexMatrix3D)A).toArray();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[][][] array = Av.toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = Av.toArray();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDComplexMatrix3D A = new DenseDComplexMatrix3D(a_3d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DComplexMatrix1D B = ((DComplexMatrix3D)A).vectorize();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix3D)A).vectorize();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D Av = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DComplexMatrix1D B = Av.vectorize();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.vectorize();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

