/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;

public class WrapperDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix1D content;

    public WrapperDComplexMatrix1D(DComplexMatrix1D newContent) {
        if (newContent != null) {
            this.setUp((int)newContent.size());
        }
        this.content = newContent;
    }

    protected DComplexMatrix1D getContent() {
        return this.content;
    }

    public synchronized double[] getQuick(int index) {
        return this.content.getQuick(index);
    }

    public Object elements() {
        return this.content.elements();
    }

    public DComplexMatrix1D like(int size) {
        return this.content.like(size);
    }

    public DComplexMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public DComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int index, double[] value) {
        this.content.setQuick(index, value);
    }

    public synchronized void setQuick(int index, double re, double im) {
        this.content.setQuick(index, re, im);
    }

    public DComplexMatrix1D viewFlip() {
        WrapperDComplexMatrix1D view = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int index) {
                return this.content.getQuick(this.size - 1 - index);
            }

            public synchronized void setQuick(int index, double[] value) {
                this.content.setQuick(this.size - 1 - index, value);
            }

            public synchronized void setQuick(int index, double re, double im) {
                this.content.setQuick(this.size - 1 - index, re, im);
            }

            public synchronized double[] get(int index) {
                return this.content.get(this.size - 1 - index);
            }

            public synchronized void set(int index, double[] value) {
                this.content.set(this.size - 1 - index, value);
            }

            public synchronized void set(int index, double re, double im) {
                this.content.set(this.size - 1 - index, re, im);
            }
        };
        return view;
    }

    public DComplexMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperDComplexMatrix1D view = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int i) {
                return this.content.getQuick(index + i);
            }

            public synchronized void setQuick(int i, double[] value) {
                this.content.setQuick(index + i, value);
            }

            public synchronized void setQuick(int i, double re, double im) {
                this.content.setQuick(index + i, re, im);
            }

            public synchronized double[] get(int i) {
                return this.content.get(index + i);
            }

            public synchronized void set(int i, double[] value) {
                this.content.set(index + i, value);
            }

            public synchronized void set(int i, double re, double im) {
                this.content.set(index + i, re, im);
            }
        };
        view.size = width;
        return view;
    }

    public DComplexMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        final int[] idx = indexes;
        WrapperDComplexMatrix1D view = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int i) {
                return this.content.getQuick(idx[i]);
            }

            public synchronized void setQuick(int i, double[] value) {
                this.content.setQuick(idx[i], value);
            }

            public synchronized void setQuick(int i, double re, double im) {
                this.content.setQuick(idx[i], re, im);
            }

            public synchronized double[] get(int i) {
                return this.content.get(idx[i]);
            }

            public synchronized void set(int i, double[] value) {
                this.content.set(idx[i], value);
            }

            public synchronized void set(int i, double re, double im) {
                this.content.set(idx[i], re, im);
            }
        };
        view.size = indexes.length;
        return view;
    }

    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }

    public DComplexMatrix1D viewStrides(final int _stride) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDComplexMatrix1D view = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int index) {
                return this.content.getQuick(index * _stride);
            }

            public synchronized void setQuick(int index, double[] value) {
                this.content.setQuick(index * _stride, value);
            }

            public synchronized void setQuick(int index, double re, double im) {
                this.content.setQuick(index * _stride, re, im);
            }

            public synchronized double[] get(int index) {
                return this.content.get(index * _stride);
            }

            public synchronized void set(int index, double[] value) {
                this.content.set(index * _stride, value);
            }

            public synchronized void set(int index, double re, double im) {
                this.content.set(index * _stride, re, im);
            }
        };
        if (this.size != 0) {
            view.size = (this.size - 1) / _stride + 1;
        }
        return view;
    }

    public DoubleMatrix1D getImaginaryPart() {
        return this.content.getImaginaryPart();
    }

    public DoubleMatrix1D getRealPart() {
        return this.content.getRealPart();
    }
}

