/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.SparseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dmperm;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_lu;
import edu.emory.mathcs.csparsej.tdouble.Dcs_sqr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_usolve;

public class CSparseDoubleLUDecomposition
implements SparseDoubleLUDecomposition {
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D L;
    private DoubleMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public CSparseDoubleLUDecomposition(DoubleMatrix2D A, int order, boolean checkIfSingular) {
        Dcs_common.Dcsd D;
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSquare(A);
        DoubleProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        if (A instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCDoubleMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (Dcs_common.Dcs)A.elements();
        }
        this.n = A.rows();
        this.S = Dcs_sqr.cs_sqr((int)order, (Dcs_common.Dcs)dcs, (boolean)false);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Dcs_lu.cs_lu((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S, (double)1.0);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_lu()");
        }
        if (checkIfSingular && (D = Dcs_dmperm.cs_dmperm((Dcs_common.Dcs)dcs, (int)1)) != null && D.rr[3] < this.n) {
            this.isNonSingular = false;
        }
    }

    public double det() {
        if (!this.isNonsingular()) {
            return 0.0;
        }
        int pivsign = 1;
        for (int i = 0; i < this.n; ++i) {
            if (this.N.pinv[i] == i) continue;
            pivsign = -pivsign;
        }
        if (this.U == null) {
            this.U = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDoubleMatrix2D)this.U).getRowCompressed();
            }
        }
        double det = pivsign;
        for (int j = 0; j < this.n; ++j) {
            det *= this.U.getQuick(j, j);
        }
        return det;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCDoubleMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.pinv == null) {
            return null;
        }
        int[] pinv = new int[this.N.pinv.length];
        System.arraycopy(this.N.pinv, 0, pinv, 0, pinv.length);
        return pinv;
    }

    public DoubleMatrix2D getU() {
        if (this.U == null) {
            this.U = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCDoubleMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public Dcs_common.Dcss getSymbolicAnalysis() {
        Dcs_common.Dcss S2 = new Dcs_common.Dcss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(DoubleMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        DoubleProperty.DEFAULT.checkDense(b);
        double[] y = new double[this.n];
        double[] x = b.isView() ? (double[])b.copy().elements() : (double[])b.elements();
        Dcs_ipvec.cs_ipvec((int[])this.N.pinv, (double[])x, (double[])y, (int)this.n);
        Dcs_lsolve.cs_lsolve((Dcs_common.Dcs)this.N.L, (double[])y);
        Dcs_usolve.cs_usolve((Dcs_common.Dcs)this.N.U, (double[])y);
        Dcs_ipvec.cs_ipvec((int[])this.S.q, (double[])y, (double[])x, (int)this.n);
        if (b.isView()) {
            b.assign(x);
        }
    }
}

