/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleMatrix2D
extends DoubleMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    private DoubleDCT_2D dct2;
    private DoubleDST_2D dst2;
    private DoubleDHT_2D dht2;
    protected double[] elements;

    public DenseDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseDoubleMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new double[rows * columns];
    }

    public DenseDoubleMatrix2D(int rows, int columns, double[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseDoubleMatrix2D(MatrixVectorReader reader) throws IOException {
        block7: {
            int i;
            double[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block6: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new double[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new double[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                for (i = 0; i < numEntries; ++i) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                }
                if (!info.isSymmetric()) break block6;
                for (i = 0; i < numEntries; ++i) {
                    if (rowIndexes[i] == columnIndexes[i]) continue;
                    this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                }
                break block7;
            }
            if (!info.isSkewSymmetric()) break block7;
            for (i = 0; i < numEntries; ++i) {
                if (rowIndexes[i] == columnIndexes[i]) continue;
                this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
            }
        }
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseDoubleMatrix2D.this.elements[zero + (firstRow - 1) * DenseDoubleMatrix2D.this.rowStride + (DenseDoubleMatrix2D.this.columns - 1) * DenseDoubleMatrix2D.this.columnStride]);
                        int d = 1;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            int ridx = zero + r * DenseDoubleMatrix2D.this.rowStride;
                            int c = DenseDoubleMatrix2D.this.columns - d;
                            while (--c >= 0) {
                                a = aggr.apply(a, f.apply(DenseDoubleMatrix2D.this.elements[ridx + c * DenseDoubleMatrix2D.this.columnStride]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int r = this.rows;
            while (--r >= 0) {
                int ridx = zero + r * this.rowStride;
                int c = this.columns - d;
                while (--c >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[ridx + c * this.columnStride]));
                }
                d = 0;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DenseDoubleMatrix2D.this.elements[zero + firstRow * DenseDoubleMatrix2D.this.rowStride];
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                elem = DenseDoubleMatrix2D.this.elements[zero + r * DenseDoubleMatrix2D.this.rowStride + c * DenseDoubleMatrix2D.this.columnStride];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = f.apply(this.elements[zero]);
            }
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseDoubleMatrix2D.this.elements[zero + rowElements[firstIdx] * DenseDoubleMatrix2D.this.rowStride + columnElements[firstIdx] * DenseDoubleMatrix2D.this.columnStride]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            double elem = DenseDoubleMatrix2D.this.elements[zero + rowElements[i] * DenseDoubleMatrix2D.this.rowStride + columnElements[i] * DenseDoubleMatrix2D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            for (int i = 1; i < size; ++i) {
                double elem = this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public double aggregate(DoubleMatrix2D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        if (!(other instanceof DenseDoubleMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final double[] elementsOther = (double[])other.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseDoubleMatrix2D.this.elements[zero + firstRow * DenseDoubleMatrix2D.this.rowStride], elementsOther[zeroOther + firstRow * rowStrideOther]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DenseDoubleMatrix2D.this.elements[zero + r * DenseDoubleMatrix2D.this.rowStride + c * DenseDoubleMatrix2D.this.columnStride], elementsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero], elementsOther[zeroOther]);
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride], elementsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    public DoubleMatrix2D assign(final DoubleFunction function) {
        final double[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof DoubleMult) {
                double multiplicator = ((DoubleMult)function).multiplicator;
                if (multiplicator == 1.0) {
                    return this;
                }
                if (multiplicator == 0.0) {
                    return this.assign(0.0);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        if (function instanceof DoubleMult) {
                            double multiplicator = ((DoubleMult)function).multiplicator;
                            if (multiplicator == 1.0) {
                                return;
                            }
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    elems[n] = elems[n] * multiplicator;
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    elems[i] = function.apply(elems[i]);
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof DoubleMult) {
                double multiplicator = ((DoubleMult)function).multiplicator;
                if (multiplicator == 1.0) {
                    return this;
                }
                if (multiplicator == 0.0) {
                    return this.assign(0.0);
                }
                int r = this.rows;
                while (--r >= 0) {
                    int i = idx;
                    int c = this.columns;
                    while (--c >= 0) {
                        int n = i;
                        elems[n] = elems[n] * multiplicator;
                        i -= this.columnStride;
                    }
                    idx -= this.rowStride;
                }
            } else {
                int r = this.rows;
                while (--r >= 0) {
                    int i = idx;
                    int c = this.columns;
                    while (--c >= 0) {
                        elems[i] = function.apply(elems[i]);
                        i -= this.columnStride;
                    }
                    idx -= this.rowStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final DoubleFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                double elem = DenseDoubleMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseDoubleMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    double elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure cond, final double value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                double elem = DenseDoubleMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseDoubleMatrix2D.this.elements[i] = value;
                                }
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    double elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double value) {
        final double[] elems = this.elements;
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                elems[i] = value;
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elems[i] = value;
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idxOther = firstRow * DenseDoubleMatrix2D.this.columns;
                            int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    DenseDoubleMatrix2D.this.elements[i] = values[idxOther++];
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = values[idxOther++];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow * DenseDoubleMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                double[] currentRow = values[r];
                                if (currentRow.length != DenseDoubleMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseDoubleMatrix2D.this.columns());
                                }
                                System.arraycopy(currentRow, 0, DenseDoubleMatrix2D.this.elements, i, DenseDoubleMatrix2D.this.columns);
                                i += DenseDoubleMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                for (int r = 0; r < this.rows; ++r) {
                    double[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i += this.columns;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                double[] currentRow = values[r];
                                if (currentRow.length != DenseDoubleMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseDoubleMatrix2D.this.columns());
                                }
                                int i = idx;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    DenseDoubleMatrix2D.this.elements[i] = currentRow[c];
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    double[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = currentRow[c];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (!(source instanceof DenseDoubleMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseDoubleMatrix2D other = (DenseDoubleMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DoubleMatrix2D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseDoubleMatrix2D)c;
        }
        final double[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                DenseDoubleMatrix2D.this.elements[i] = elementsOther[j];
                                i += DenseDoubleMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, final DoubleDoubleFunction function) {
        if (!(y instanceof DenseDoubleMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseDoubleMatrix2D other = (DenseDoubleMatrix2D)y;
        this.checkShape(y);
        final double[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            double multiplicator;
            if (function instanceof DoublePlusMultSecond && (multiplicator = ((DoublePlusMultSecond)function).multiplicator) == 0.0) {
                return this;
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (function == DoubleFunctions.mult) {
                            int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    DenseDoubleMatrix2D.this.elements[n] = DenseDoubleMatrix2D.this.elements[n] * elementsOther[j];
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function == DoubleFunctions.div) {
                            int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    int n = i;
                                    DenseDoubleMatrix2D.this.elements[n] = DenseDoubleMatrix2D.this.elements[n] / elementsOther[j];
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function instanceof DoublePlusMultSecond) {
                            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
                            if (multiplicator == 1.0) {
                                int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseDoubleMatrix2D.this.elements[n] = DenseDoubleMatrix2D.this.elements[n] + elementsOther[j];
                                        i += DenseDoubleMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseDoubleMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            } else if (multiplicator == -1.0) {
                                int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseDoubleMatrix2D.this.elements[n] = DenseDoubleMatrix2D.this.elements[n] - elementsOther[j];
                                        i += DenseDoubleMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseDoubleMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            } else {
                                int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                for (int r = firstRow; r < lastRow; ++r) {
                                    int i = idx;
                                    int j = idxOther;
                                    for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                        int n = i;
                                        DenseDoubleMatrix2D.this.elements[n] = DenseDoubleMatrix2D.this.elements[n] + multiplicator * elementsOther[j];
                                        i += DenseDoubleMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                    }
                                    idx += DenseDoubleMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                }
                            }
                        } else {
                            int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                    DenseDoubleMatrix2D.this.elements[i] = function.apply(DenseDoubleMatrix2D.this.elements[i], elementsOther[j]);
                                    i += DenseDoubleMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDoubleMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else if (function == DoubleFunctions.mult) {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    int n = i;
                    this.elements[n] = this.elements[n] * elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        } else if (function == DoubleFunctions.div) {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    int n = i;
                    this.elements[n] = this.elements[n] / elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        } else if (function instanceof DoublePlusMultSecond) {
            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
            if (multiplicator == 0.0) {
                return this;
            }
            if (multiplicator == 1.0) {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] + elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else if (multiplicator == -1.0) {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] - elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else {
                int idx = zero;
                int idxOther = zeroOther;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        int n = i;
                        this.elements[n] = this.elements[n] + multiplicator * elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = function.apply(this.elements[i], elementsOther[j]);
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, final DoubleDoubleFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final double[] elementsOther = (double[])y.elements();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx = zero + rowElements[i] * DenseDoubleMatrix2D.this.rowStride + columnElements[i] * DenseDoubleMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseDoubleMatrix2D.this.elements[idx] = function.apply(DenseDoubleMatrix2D.this.elements[idx], elementsOther[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        int idxOther = firstRow * DenseDoubleMatrix2D.this.columns;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                DenseDoubleMatrix2D.this.elements[i] = values[idxOther++];
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = 0;
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = values[idxOther++];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                if (DenseDoubleMatrix2D.this.elements[i] != 0.0) {
                                    ++cardinality;
                                }
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    if (this.elements[i] != 0.0) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return cardinality;
    }

    public void dct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.forward(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dct2.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).dct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dct(scale);
            }
        }
    }

    public void dctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).dct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dct(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.forward(this.elements);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dht2.forward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.forward(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dst2.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).dst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).dst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).dst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).dst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realForward(this.elements);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.fft2.realForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                double value = DenseDoubleMatrix2D.this.elements[i];
                                if (value != 0.0) {
                                    DenseDoubleMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    double value = this.elements[i];
                    if (value != 0.0) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    public DenseColumnDoubleMatrix2D getColumnMajor() {
        DenseColumnDoubleMatrix2D R = new DenseColumnDoubleMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final double[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseDoubleMatrix2D.this.rowStride;
                        int idxR = zeroR + (firstRow - 1) * rowStrideR;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxR;
                            int c = 0;
                            while (r < DenseDoubleMatrix2D.this.columns) {
                                elementsR[j] = DenseDoubleMatrix2D.this.elements[i];
                                i += DenseDoubleMatrix2D.this.rowStride;
                                j += rowStrideR;
                                ++c;
                            }
                            idx += DenseDoubleMatrix2D.this.columnStride;
                            idxR += columnStrideR;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxR = zeroR;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxR;
                int c = 0;
                while (r < this.columns) {
                    elementsR[j] = this.elements[i];
                    i += this.rowStride;
                    j += rowStrideR;
                    ++c;
                }
                idx += this.columnStride;
                idxR += columnStrideR;
            }
        }
        return R;
    }

    public DenseDComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        final double[] elementsA = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(elementsA, r * DenseDoubleMatrix2D.this.columns, elementsC, r * DenseDoubleMatrix2D.this.columns, DenseDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(elementsA, r * this.columns, elementsC, r * this.columns, this.columns);
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getFftColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            C.viewColumn(c).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                C.viewColumn(c).assign(((DenseDoubleMatrix1D)this.viewColumn(c)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getFftRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            C.viewRow(r).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                C.viewRow(r).assign(((DenseDoubleMatrix1D)this.viewRow(r)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        final double[] elementsC = C.elements();
        final double[] elementsA = this.isNoView ? this.elements : (double[])this.copy().elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            System.arraycopy(elementsA, r * DenseDoubleMatrix2D.this.columns, elementsC, r * DenseDoubleMatrix2D.this.columns, DenseDoubleMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(elementsA, r * this.columns, elementsC, r * this.columns, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getIfftColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            C.viewColumn(c).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).getIfft(scale));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                C.viewColumn(c).assign(((DenseDoubleMatrix1D)this.viewColumn(c)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix2D getIfftRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            C.viewRow(r).assign(((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).getIfft(scale));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                C.viewRow(r).assign(((DenseDoubleMatrix1D)this.viewRow(r)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public double[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double maxValue = DenseDoubleMatrix2D.this.elements[zero + firstRow * DenseDoubleMatrix2D.this.rowStride];
                        int rowLocation = firstRow;
                        int colLocation = 0;
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                double elem = DenseDoubleMatrix2D.this.elements[zero + r * DenseDoubleMatrix2D.this.rowStride + c * DenseDoubleMatrix2D.this.columnStride];
                                if (!(maxValue < elem)) continue;
                                maxValue = elem;
                                rowLocation = r;
                                colLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{maxValue, rowLocation, colLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    double elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (!(maxValue < elem)) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{maxValue, rowLocation, columnLocation};
    }

    public double[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        double minValue = DenseDoubleMatrix2D.this.elements[zero + firstRow * DenseDoubleMatrix2D.this.rowStride];
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                double elem = DenseDoubleMatrix2D.this.elements[zero + r * DenseDoubleMatrix2D.this.rowStride + c * DenseDoubleMatrix2D.this.columnStride];
                                if (!(minValue > elem)) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new double[]{minValue, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    rowLocation = (int)results[j][1];
                    columnLocation = (int)results[j][2];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    double elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (!(minValue > elem)) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new double[]{minValue, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                double value = this.elements[i];
                if (value < 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                double value = this.elements[i];
                if (value != 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                double value = this.elements[i];
                if (value > 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    public double getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new DoubleDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.inverse(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dct2.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).idct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idct(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).idct(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idct(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new DoubleDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.inverse(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dht2.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).idht(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idht(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).idht(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idht(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new DoubleDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.inverse(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.dst2.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewColumn(c)).idst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDoubleMatrix1D)this.viewColumn(c)).idst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDoubleMatrix1D)DenseDoubleMatrix2D.this.viewRow(r)).idst(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDoubleMatrix1D)this.viewRow(r)).idst(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realInverse(this.elements, scale);
        } else {
            DoubleMatrix2D copy = this.copy();
            this.fft2.realInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    public void setQuick(int row, int column, double value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    public double[][] toArray() {
        final double[][] values = new double[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] currentRow = values[r];
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                currentRow[c] = DenseDoubleMatrix2D.this.elements[i];
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                double[] currentRow = values[r];
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    currentRow[c] = this.elements[i];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return values;
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D v = new DenseDoubleMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)v.index(0);
        final int strideOther = v.stride();
        final double[] elementsOther = v.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + firstColumn * DenseDoubleMatrix2D.this.rows;
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            idx = zero + c * DenseDoubleMatrix2D.this.columnStride;
                            for (int r = 0; r < DenseDoubleMatrix2D.this.rows; ++r) {
                                elementsOther[idxOther] = DenseDoubleMatrix2D.this.elements[idx];
                                idx += DenseDoubleMatrix2D.this.rowStride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int c = 0; c < this.columns; ++c) {
                idx = zero + c * this.columnStride;
                for (int r = 0; r < this.rows; ++r) {
                    elementsOther[idxOther] = this.elements[idx];
                    idx += this.rowStride;
                    idxOther += strideOther;
                }
            }
        }
        return v;
    }

    public void zAssign8Neighbors(DoubleMatrix2D B, Double9Function function) {
        if (!(B instanceof DenseDoubleMatrix2D)) {
            super.zAssign8Neighbors(B, function);
            return;
        }
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        int r = this.rows - 1;
        int c = this.columns - 1;
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        DenseDoubleMatrix2D BB = (DenseDoubleMatrix2D)B;
        int A_rs = this.rowStride;
        int B_rs = BB.rowStride;
        int A_cs = this.columnStride;
        int B_cs = BB.columnStride;
        double[] elems = this.elements;
        double[] B_elems = BB.elements;
        if (elems == null || B_elems == null) {
            throw new InternalError();
        }
        int A_index = (int)this.index(1, 1);
        int B_index = (int)BB.index(1, 1);
        for (int i = 1; i < r; ++i) {
            int B11 = B_index;
            int A02 = A_index - A_rs - A_cs;
            int A12 = A02 + A_rs;
            int A22 = A12 + A_rs;
            double a00 = elems[A02];
            double a01 = elems[A02 += A_cs];
            double a10 = elems[A12];
            double a11 = elems[A12 += A_cs];
            double a20 = elems[A22];
            double a21 = elems[A22 += A_cs];
            for (int j = 1; j < c; ++j) {
                double a02 = elems[A02 += A_cs];
                double a12 = elems[A12 += A_cs];
                double a22 = elems[A22 += A_cs];
                B_elems[B11] = function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22);
                B11 += B_cs;
                a00 = a01;
                a01 = a02;
                a10 = a11;
                a11 = a12;
                a20 = a21;
                a21 = a22;
            }
            A_index += A_rs;
            B_index += B_rs;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, final double beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseDoubleMatrix1D(this.rows);
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)this.columns != y.size() || (long)this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        final double[] elemsY = (double[])y.elements();
        final double[] elemsZ = (double[])z.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = z.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)z.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idxZero = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        for (int r = firstRow; r < lastRow; ++r) {
                            double sum = 0.0;
                            int idx = idxZero;
                            int idxY = zeroY;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                sum += DenseDoubleMatrix2D.this.elements[idx] * elemsY[idxY];
                                idx += DenseDoubleMatrix2D.this.columnStride;
                                idxY += strideY;
                            }
                            elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                            idxZero += DenseDoubleMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            for (int r = 0; r < this.rows; ++r) {
                double sum = 0.0;
                int idx = idxZero;
                int idxY = zeroY;
                for (int c = 0; c < this.columns; ++c) {
                    sum += this.elements[idx] * elemsY[idxY];
                    idx += this.columnStride;
                    idxY += strideY;
                }
                elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
            }
        }
        return z;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, final double beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseDoubleMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseDoubleMatrix2D || B instanceof SparseRCDoubleMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        if (!(C instanceof DenseDoubleMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSequential(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            DoubleMatrix2D CC;
            DoubleMatrix2D BB;
            DoubleMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseDoubleMatrix2D)AA).zMultSequential(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    public double zSum() {
        double sum = 0.0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        int idx = zero + firstRow * DenseDoubleMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDoubleMatrix2D.this.columns; ++c) {
                                sum += DenseDoubleMatrix2D.this.elements[i];
                                i += DenseDoubleMatrix2D.this.columnStride;
                            }
                            idx += DenseDoubleMatrix2D.this.rowStride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    sum += ((Double)futures[j].get()).doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    sum += this.elements[i];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return sum;
    }

    private DoubleMatrix2D zMultSequential(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseDoubleMatrix2D || B instanceof SparseRCDoubleMatrix2D || B instanceof SparseCCDoubleMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseDoubleMatrix2D(rowsA, p);
        }
        if (!(B instanceof DenseDoubleMatrix2D) || !(C instanceof DenseDoubleMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDoubleMatrix2D BB = (DenseDoubleMatrix2D)B;
        DenseDoubleMatrix2D CC = (DenseDoubleMatrix2D)C;
        double[] AElems = this.elements;
        double[] BElems = BB.elements;
        double[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - columnsA) / (columnsA + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = rowsA / m_optimal;
        int rr = 0;
        if (rowsA % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += rowsA - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    int kA = iA;
                    int kB = jB;
                    double s = 0.0;
                    kA -= cA;
                    kB -= rB;
                    int k = columnsA % 4;
                    while (--k >= 0) {
                        s += AElems[kA += cA] * BElems[kB += rB];
                    }
                    k = columnsA / 4;
                    while (--k >= 0) {
                        int n = kA + cA;
                        kA = n;
                        int n2 = kB + rB;
                        kB = n2;
                        int n3 = kA + cA;
                        kA = n3;
                        int n4 = kB + rB;
                        kB = n4;
                        kA = kA + cA;
                        kB = kB + rB;
                        s += AElems[n] * BElems[n2] + AElems[n3] * BElems[n4] + AElems[kA] * BElems[kB] + AElems[kA += cA] * BElems[kB += rB];
                    }
                    CElems[iC] = alpha * s + beta * CElems[iC];
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        if (other instanceof SelectedDenseDoubleMatrix2D) {
            SelectedDenseDoubleMatrix2D otherMatrix = (SelectedDenseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D otherMatrix = (DenseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected DoubleMatrix1D like1D(int size, int zero, int stride) {
        return new DenseDoubleMatrix1D(size, this.elements, zero, stride, true);
    }

    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDoubleMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

