/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;

public class FComplexFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FComplexFactory2D dense = new FComplexFactory2D();
    public static final FComplexFactory2D sparse = new FComplexFactory2D();

    protected FComplexFactory2D() {
    }

    public FComplexMatrix2D appendColumns(FComplexMatrix2D A, FComplexMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        FComplexMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public FComplexMatrix2D appendColumn(FComplexMatrix2D A, FComplexMatrix1D b) {
        if (b.size() > (long)A.rows()) {
            b = b.viewPart(0, A.rows());
        } else if (b.size() < (long)A.rows()) {
            A = A.viewPart(0, 0, (int)b.size(), A.columns());
        }
        int ac = A.columns();
        int bc = 1;
        int r = A.rows();
        FComplexMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewColumn(ac).assign(b);
        return matrix;
    }

    public FComplexMatrix2D appendRows(FComplexMatrix2D A, FComplexMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        FComplexMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public FComplexMatrix2D appendRow(FComplexMatrix2D A, FComplexMatrix1D b) {
        if (b.size() > (long)A.columns()) {
            b = b.viewPart(0, A.columns());
        } else if (b.size() < (long)A.columns()) {
            A = A.viewPart(0, 0, A.rows(), (int)b.size());
        }
        int ar = A.rows();
        int br = 1;
        int c = A.columns();
        FComplexMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewRow(ar).assign(b);
        return matrix;
    }

    protected static void checkRectangularShape(float[][] array) {
        int columns = -1;
        for (int r = 0; r < array.length; ++r) {
            if (array[r] == null) continue;
            if (columns == -1) {
                columns = array[r].length;
            }
            if (array[r].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(FComplexMatrix2D[][] array) {
        int columns = -1;
        for (int r = 0; r < array.length; ++r) {
            if (array[r] == null) continue;
            if (columns == -1) {
                columns = array[r].length;
            }
            if (array[r].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public FComplexMatrix2D compose(FComplexMatrix2D[][] parts) {
        int r;
        FComplexFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        FComplexMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        for (int c = 0; c < columns; ++c) {
            int maxWidth = 0;
            for (r = 0; r < rows; ++r) {
                FComplexMatrix2D part = parts[r][c];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[c] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        for (int r2 = 0; r2 < rows; ++r2) {
            int maxHeight = 0;
            for (int c = 0; c < columns; ++c) {
                FComplexMatrix2D part = parts[r2][c];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[r2] = maxHeight;
        }
        int resultRows = 0;
        for (r = 0; r < rows; ++r) {
            resultRows += maxHeights[r];
        }
        int resultCols = 0;
        for (int c = 0; c < columns; ++c) {
            resultCols += maxWidths[c];
        }
        FComplexMatrix2D matrix = this.make(resultRows, resultCols);
        int idxr = 0;
        for (int r3 = 0; r3 < rows; ++r3) {
            int idxc = 0;
            for (int c = 0; c < columns; ++c) {
                FComplexMatrix2D part = parts[r3][c];
                if (part != null) {
                    matrix.viewPart(idxr, idxc, part.rows(), part.columns()).assign(part);
                }
                idxc += maxWidths[c];
            }
            idxr += maxHeights[r3];
        }
        return matrix;
    }

    public FComplexMatrix2D composeDiagonal(FComplexMatrix2D A, FComplexMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        FComplexMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public FComplexMatrix2D composeDiagonal(FComplexMatrix2D A, FComplexMatrix2D B, FComplexMatrix2D C) {
        FComplexMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public FComplexMatrix2D composeBidiagonal(FComplexMatrix2D A, FComplexMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        FComplexMatrix2D sum = this.make(ar + br - 1, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar - 1, ac, br, bc).assign(B);
        return sum;
    }

    public void decompose(FComplexMatrix2D[][] parts, FComplexMatrix2D matrix) {
        int r;
        FComplexFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        for (int c = 0; c < columns; ++c) {
            int maxWidth = 0;
            for (r = 0; r < rows; ++r) {
                FComplexMatrix2D part = parts[r][c];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[c] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        for (int r2 = 0; r2 < rows; ++r2) {
            int maxHeight = 0;
            for (int c = 0; c < columns; ++c) {
                FComplexMatrix2D part = parts[r2][c];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[r2] = maxHeight;
        }
        int resultRows = 0;
        for (r = 0; r < rows; ++r) {
            resultRows += maxHeights[r];
        }
        int resultCols = 0;
        for (int c = 0; c < columns; ++c) {
            resultCols += maxWidths[c];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int idxr = 0;
        for (int r3 = 0; r3 < rows; ++r3) {
            int idxc = 0;
            for (int c = 0; c < columns; ++c) {
                FComplexMatrix2D part = parts[r3][c];
                if (part != null) {
                    part.assign(matrix.viewPart(idxr, idxc, part.rows(), part.columns()));
                }
                idxc += maxWidths[c];
            }
            idxr += maxHeights[r3];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        FComplexMatrix2D[][] parts1 = new FComplexMatrix2D[][]{{null, this.make(2, 2, new float[]{1.0f, 2.0f}), null}, {this.make(4, 4, new float[]{3.0f, 4.0f}), null, this.make(4, 3, new float[]{5.0f, 6.0f})}, {null, this.make(2, 2, new float[]{7.0f, 8.0f}), null}};
        System.out.println("\n" + this.compose(parts1));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        FComplexMatrix2D A = this.make(2, 2, new float[]{1.0f, 2.0f});
        FComplexMatrix2D B = this.make(4, 4, new float[]{3.0f, 4.0f});
        FComplexMatrix2D C = this.make(4, 3, new float[]{5.0f, 6.0f});
        FComplexMatrix2D D = this.make(2, 2, new float[]{7.0f, 8.0f});
        FComplexMatrix2D[][] parts1 = new FComplexMatrix2D[][]{{_, A, _}, {B, _, C}, {_, D, _}};
        FComplexMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A.assign(9.0f, 9.0f);
        B.assign(9.0f, 9.0f);
        C.assign(9.0f, 9.0f);
        D.assign(9.0f, 9.0f);
        this.decompose(parts1, matrix);
        System.out.println(A);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public FComplexMatrix2D diagonal(FComplexMatrix1D vector) {
        int size = (int)vector.size();
        FComplexMatrix2D diag = this.make(size, size);
        for (int i = 0; i < size; ++i) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public FComplexMatrix1D diagonal(FComplexMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        FComplexMatrix1D diag = this.make1D(min);
        for (int i = 0; i < min; ++i) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public FComplexMatrix2D identity(int rowsAndColumns) {
        FComplexMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        float[] one = new float[]{1.0f, 0.0f};
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, one);
        }
        return matrix;
    }

    public FComplexMatrix2D make(float[][] values) {
        if (this == sparse) {
            return new SparseFComplexMatrix2D(values);
        }
        return new DenseFComplexMatrix2D(values);
    }

    public FComplexMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseFComplexMatrix2D(rows, columns);
        }
        return new DenseFComplexMatrix2D(rows, columns);
    }

    public FComplexMatrix2D make(int rows, int columns, float[] initialValue) {
        if (initialValue[0] == 0.0f && initialValue[1] == 0.0f) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected FComplexMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public FComplexMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(FComplexFunctions.random());
    }

    public FComplexMatrix2D repeat(FComplexMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        FComplexMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        for (int i = 0; i < rowRepeat; ++i) {
            for (int j = 0; j < columnRepeat; ++j) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }

    public FComplexMatrix2D sample(int rows, int columns, float[] value, float nonZeroFraction) {
        FComplexMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public FComplexMatrix2D sample(FComplexMatrix2D matrix, float[] value, float nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        float epsilon = 1.0E-5f;
        if (nonZeroFraction < 0.0f - epsilon || nonZeroFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0f) {
            nonZeroFraction = 0.0f;
        }
        if (nonZeroFraction > 1.0f) {
            nonZeroFraction = 1.0f;
        }
        matrix.assign(0.0f, 0.0f);
        int size = rows * columns;
        int n = Math.round((float)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        FloatRandomSamplingAssistant sampler = new FloatRandomSamplingAssistant(n, size, new FloatMersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            int row = i / columns;
            int column = i % columns;
            matrix.set(row, column, value);
        }
        return matrix;
    }
}

