/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;

public class SparseCCMFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseFComplexMatrix1D[] elements;

    public SparseCCMFComplexMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseFComplexMatrix1D[columns];
        for (int i = 0; i < columns; ++i) {
            this.elements[i] = new SparseFComplexMatrix1D(rows);
        }
    }

    public SparseFComplexMatrix1D[] elements() {
        return this.elements;
    }

    public float[] getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    public void setQuick(int row, int column, float[] value) {
        this.elements[column].setQuick(row, value);
    }

    public void setQuick(int row, int column, float re, float im) {
        this.elements[column].setQuick(row, re, im);
    }

    public void trimToSize() {
        for (int c = 0; c < this.columns; ++c) {
            this.elements[c].trimToSize();
        }
    }

    public SparseFComplexMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseCCMFComplexMatrix2D(rows, columns);
    }
}

