/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.MRNSDFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatMRNSD
extends AbstractFloatIterativeSolver {
    private static final DenseFloatAlgebra alg = DenseFloatAlgebra.DEFAULT;
    public static final float sqrteps = (float)Math.sqrt(Math.pow(2.0, -52.0));

    public FloatMRNSD() {
        this.iter = new MRNSDFloatIterationMonitor();
        ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        float rnrm;
        float gamma;
        float tau;
        if (!(this.iter instanceof MRNSDFloatIterationMonitor)) {
            this.iter = new MRNSDFloatIterationMonitor();
            ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
        }
        float sigsq = tau = sqrteps;
        float[] minAndLoc = x.getMinLocation();
        float minX = minAndLoc[0];
        if (minX < 0.0f) {
            x.assign(FloatFunctions.plus(-minX + sigsq));
        }
        if ((double)((MRNSDFloatIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(A.zMult(b, null, 1.0f, 0.0f, true)));
        }
        FloatMatrix1D r = A.zMult(x, null);
        r.assign(b, FloatFunctions.plusMultFirst(-1.0f));
        if (!(this.M instanceof FloatIdentity)) {
            r = this.M.apply(r, null);
            r = this.M.transApply(r, null);
            r = A.zMult(r, null, 1.0f, 0.0f, true);
            r.assign(FloatFunctions.neg);
            gamma = x.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
            rnrm = alg.norm2(r);
        } else {
            r = A.zMult(r, null, 1.0f, 0.0f, true);
            r.assign(FloatFunctions.neg);
            gamma = x.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
            rnrm = (float)Math.sqrt(gamma);
        }
        IntArrayList indexList = new IntArrayList((int)b.size());
        this.iter.setFirst();
        while (!this.iter.converged(rnrm, x)) {
            FloatMatrix1D s = x.copy();
            s.assign(r, FloatFunctions.multNeg);
            FloatMatrix1D u = A.zMult(s, null);
            if (!(this.M instanceof FloatIdentity)) {
                u = this.M.apply(u, null);
            }
            float theta = gamma / u.aggregate(FloatFunctions.plus, FloatFunctions.square);
            s.getNegativeValues(indexList, null);
            FloatMatrix1D w = x.copy();
            w.assign(s, FloatFunctions.divNeg, indexList);
            float alpha = Math.min(theta, w.aggregate(FloatFunctions.min, FloatFunctions.identity, indexList));
            x.assign(s, FloatFunctions.plusMultSecond(alpha));
            if (!(this.M instanceof FloatIdentity)) {
                w = this.M.transApply(u, null);
                w = A.zMult(w, null, 1.0f, 0.0f, true);
                r.assign(w, FloatFunctions.plusMultSecond(alpha));
                gamma = x.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
                rnrm = alg.norm2(r);
            } else {
                w = A.zMult(u, null, 1.0f, 0.0f, true);
                r.assign(w, FloatFunctions.plusMultSecond(alpha));
                gamma = x.aggregate(r, FloatFunctions.plus, FloatFunctions.multSquare);
                rnrm = (float)Math.sqrt(gamma);
            }
            this.iter.next();
        }
        return x;
    }
}

