/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatQMR
extends AbstractFloatIterativeSolver {
    private FloatPreconditioner M1;
    private FloatPreconditioner M2;
    private FloatMatrix1D r;
    private FloatMatrix1D y;
    private FloatMatrix1D z;
    private FloatMatrix1D v;
    private FloatMatrix1D w;
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D d;
    private FloatMatrix1D s;
    private FloatMatrix1D v_tld;
    private FloatMatrix1D w_tld;
    private FloatMatrix1D y_tld;
    private FloatMatrix1D z_tld;
    private FloatMatrix1D p_tld;

    public FloatQMR(FloatMatrix1D template) {
        this.M1 = this.M;
        this.M2 = this.M;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    public FloatQMR(FloatMatrix1D template, FloatPreconditioner M1, FloatPreconditioner M2) {
        this.M1 = M1;
        this.M2 = M2;
        this.r = template.copy();
        this.y = template.copy();
        this.z = template.copy();
        this.v = template.copy();
        this.w = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.d = template.copy();
        this.s = template.copy();
        this.v_tld = template.copy();
        this.w_tld = template.copy();
        this.y_tld = template.copy();
        this.z_tld = template.copy();
        this.p_tld = template.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float rho = 0.0f;
        float rho_1 = 0.0f;
        float xi = 0.0f;
        float gamma = 1.0f;
        float gamma_1 = 0.0f;
        float theta = 0.0f;
        float theta_1 = 0.0f;
        float eta = -1.0f;
        float delta = 0.0f;
        float ep = 0.0f;
        float beta = 0.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.v_tld.assign(this.r);
        this.M1.apply(this.v_tld, this.y);
        rho = DenseFloatAlgebra.DEFAULT.norm(this.y, Norm.Two);
        this.w_tld.assign(this.r);
        this.M2.transApply(this.w_tld, this.z);
        xi = DenseFloatAlgebra.DEFAULT.norm(this.z, Norm.Two);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            if (rho == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (xi == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "xi", this.iter);
            }
            this.v.assign(this.v_tld, FloatFunctions.multSecond(1.0f / rho));
            this.y.assign(FloatFunctions.mult(1.0f / rho));
            this.w.assign(this.w_tld, FloatFunctions.multSecond(1.0f / xi));
            this.z.assign(FloatFunctions.mult(1.0f / xi));
            delta = this.z.zDotProduct(this.y);
            if (delta == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "delta", this.iter);
            }
            this.M2.apply(this.y, this.y_tld);
            this.M1.transApply(this.z, this.z_tld);
            if (this.iter.isFirst()) {
                this.p.assign(this.y_tld);
                this.q.assign(this.z_tld);
            } else {
                this.p.assign(this.y_tld, FloatFunctions.plusMultFirst(-xi * delta / ep));
                this.q.assign(this.z_tld, FloatFunctions.plusMultFirst(-rho * delta / ep));
            }
            A.zMult(this.p, this.p_tld);
            ep = this.q.zDotProduct(this.p_tld);
            if (ep == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "ep", this.iter);
            }
            beta = ep / delta;
            if (beta == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "beta", this.iter);
            }
            this.v_tld.assign(this.v, FloatFunctions.multSecond(-beta)).assign(this.p_tld, FloatFunctions.plus);
            this.M1.apply(this.v_tld, this.y);
            rho_1 = rho;
            rho = DenseFloatAlgebra.DEFAULT.norm(this.y, Norm.Two);
            A.zMult(this.q, this.w_tld.assign(this.w, FloatFunctions.multSecond(-beta)), 1.0f, 1.0f, true);
            this.M2.transApply(this.w_tld, this.z);
            xi = DenseFloatAlgebra.DEFAULT.norm(this.z, Norm.Two);
            gamma_1 = gamma;
            theta_1 = theta;
            theta = rho / (gamma_1 * beta);
            gamma = 1.0f / (float)Math.sqrt(1.0f + theta * theta);
            if (gamma == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "gamma", this.iter);
            }
            eta = -eta * rho_1 * gamma * gamma / (beta * gamma_1 * gamma_1);
            if (this.iter.isFirst()) {
                this.d.assign(this.p, FloatFunctions.multSecond(eta));
                this.s.assign(this.p_tld, FloatFunctions.multSecond(eta));
            } else {
                float val = theta_1 * theta_1 * gamma * gamma;
                this.d.assign(FloatFunctions.mult(val)).assign(this.p, FloatFunctions.plusMultSecond(eta));
                this.s.assign(FloatFunctions.mult(val)).assign(this.p_tld, FloatFunctions.plusMultSecond(eta));
            }
            x.assign(this.d, FloatFunctions.plus);
            this.r.assign(this.s, FloatFunctions.minus);
            this.iter.next();
        }
        return x;
    }

    public void setPreconditioner(FloatPreconditioner M) {
        super.setPreconditioner(M);
        this.M1 = M;
        this.M2 = M;
    }
}

