/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class BenchmarkSparseCCFloatMatrix2D {
    private static final Timer t = new Timer();
    private static int niters = 200;
    private static int[] nthreads;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java cern.colt.matrix.tfloat.impl.BenchmarkSparseCCFloatMatrix2D fileName nthreads1 [nthreads2 ... nthreadsn]");
            System.exit(-1);
        }
        nthreads = new int[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            BenchmarkSparseCCFloatMatrix2D.nthreads[i - 1] = Integer.parseInt(args[i]);
        }
        BenchmarkSparseCCFloatMatrix2D.benchmarkZMult(args[0]);
    }

    public static void benchmarkZMult(String fileName) {
        SparseCCFloatMatrix2D A = null;
        File file = new File(fileName);
        try {
            A = new SparseFloatMatrix2D(new MatrixVectorReader(new FileReader(file))).getColumnCompressed(false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Benchmark of SparseCCFloatMatrix2D (" + file.getName() + ")");
        int rows = A.rows();
        int nnz = A.cardinality();
        FloatMatrix1D x = FloatFactory1D.dense.make(rows, 1.0f);
        for (int n = 0; n < nthreads.length; ++n) {
            ConcurrencyUtils.setNumberOfThreads(nthreads[n]);
            System.out.println("\tNumber of threads = " + nthreads[n]);
            FloatMatrix1D y = A.zMult(x, null, 1.0f, 0.0f, false);
            y = A.zMult(x, null, 1.0f, 0.0f, false);
            t.reset().start();
            for (int i = 0; i < niters; ++i) {
                y = A.zMult(x, null, 1.0f, 0.0f, false);
            }
            t.stop();
            double time = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-vec-mult = " + (double)(2 * nnz) / time + " megaFLOPS");
            y = A.zMult(x, null, 1.0f, 0.0f, true);
            y = A.zMult(x, null, 1.0f, 0.0f, true);
            t.reset().start();
            for (int i = 0; i < niters; ++i) {
                y = A.zMult(x, null, 1.0f, 0.0f, true);
            }
            t.stop();
            time = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-trans-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-trans-vec-mult = " + (double)(2 * nnz) / time + " megaFLOPS");
        }
    }
}

