/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;

class SelectedSparseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongFloatMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseFloatMatrix1D(AbstractLongFloatMap elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedSparseFloatMatrix1D(int size, AbstractLongFloatMap elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public float getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    public FloatMatrix1D like(int size) {
        return new SparseFloatMatrix1D(size);
    }

    public FloatMatrix2D like2D(int rows, int columns) {
        return new SparseFloatMatrix2D(rows, columns);
    }

    public FloatMatrix2D reshape(int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        SparseFloatMatrix2D M = new SparseFloatMatrix2D(rows, columns);
        int idx = 0;
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                ((FloatMatrix2D)M).setQuick(r, c, this.getQuick(idx++));
            }
        }
        return M;
    }

    public FloatMatrix3D reshape(int slices, int rows, int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        SparseFloatMatrix3D M = new SparseFloatMatrix3D(slices, rows, columns);
        int idx = 0;
        for (int s = 0; s < slices; ++s) {
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    ((FloatMatrix3D)M).setQuick(s, r, c, this.getQuick(idx++));
                }
            }
        }
        return M;
    }

    public void setQuick(int index, float value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value == 0.0f) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D other) {
        if (other instanceof SelectedSparseFloatMatrix1D) {
            SelectedSparseFloatMatrix1D otherMatrix = (SelectedSparseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseFloatMatrix1D) {
            SparseFloatMatrix1D otherMatrix = (SparseFloatMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    protected FloatMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseFloatMatrix1D(this.elements, offsets);
    }
}

