/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.algo.LongMatrix1DComparator;
import cern.colt.matrix.tlong.algo.LongMatrix2DComparator;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;

public class LongSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongSorting quickSort = new LongSorting();
    public static final LongSorting mergeSort = new LongSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected LongSorting() {
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.parallelQuickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public LongMatrix1D sort(LongMatrix1D vector) {
        return vector.viewSelection(this.sortIndex(vector));
    }

    public int[] sortIndex(final LongMatrix1D vector) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseLongMatrix1D) {
            final long[] velems = (long[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    long av = velems[idxa];
                    int idxb = zero + b * stride;
                    long bv = velems[idxb];
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    long bv;
                    long av = vector.getQuick(a);
                    return av < (bv = vector.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public LongMatrix1D sort(LongMatrix1D vector, LongComparator c) {
        return vector.viewSelection(this.sortIndex(vector, c));
    }

    public int[] sortIndex(final LongMatrix1D vector, final LongComparator c) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseLongMatrix1D) {
            final long[] velems = (long[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    return c.compare(velems[idxa], velems[idxb]);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    return c.compare(vector.getQuick(a), vector.getQuick(b));
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public LongMatrix2D sort(LongMatrix2D matrix, final long[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int x, int y) {
                long a = aggregates[x];
                long b = aggregates[y];
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                long t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public LongMatrix2D sort(LongMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final LongMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                long bv;
                long av = col.getQuick(a);
                return av < (bv = col.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public LongMatrix2D sort(LongMatrix2D matrix, final LongMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final LongMatrix1D[] views = new LongMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public LongMatrix3D sort(LongMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final LongMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                long bv;
                long av = sliceView.getQuick(a);
                return av < (bv = sliceView.getQuick(b)) ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public LongMatrix3D sort(LongMatrix3D matrix, final LongMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final LongMatrix2D[] views = new LongMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }
}

