/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;

public class SparseCCMObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseObjectMatrix1D[] elements;

    public SparseCCMObjectMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseObjectMatrix1D[columns];
        for (int i = 0; i < columns; ++i) {
            this.elements[i] = new SparseObjectMatrix1D(rows);
        }
    }

    public SparseObjectMatrix1D[] elements() {
        return this.elements;
    }

    public Object getQuick(int row, int column) {
        return this.elements[column].getQuick(row);
    }

    public void setQuick(int row, int column, Object value) {
        this.elements[column].setQuick(row, value);
    }

    public void trimToSize() {
        for (int c = 0; c < this.columns; ++c) {
            this.elements[c].trimToSize();
        }
    }

    public SparseObjectMatrix1D viewColumn(int column) {
        return this.elements[column];
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseCCMObjectMatrix2D(rows, columns);
    }
}

