/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;
import java.util.Arrays;

public class SparseRCObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected Object[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCObjectMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCObjectMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new Object[nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCObjectMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, Object value, boolean sortColumnIndexes) {
        int k;
        block7: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new Object[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = value;
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCObjectMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, Object[] values, boolean removeZeroes, boolean sortColumnIndexes) {
        int k;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new Object[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
        }
        this.cumsum(this.rowPointers, w, rows);
        for (k = 0; k < nz; ++k) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = values[k];
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCObjectMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, Object[] values) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    public ObjectMatrix2D assign(final ObjectFunction function) {
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int i, int j, Object value) {
                return function.apply(value);
            }
        });
        return this;
    }

    public ObjectMatrix2D assign(Object value) {
        if (value == null) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, null);
        } else {
            int nnz = this.cardinality();
            for (int i = 0; i < nnz; ++i) {
                this.values[i] = value;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCObjectMatrix2D) {
            SparseRCObjectMatrix2D other = (SparseRCObjectMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new Object[nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, nzmax);
            this.columnIndexesSorted = other.columnIndexesSorted;
        } else if (source instanceof SparseCCObjectMatrix2D) {
            SparseCCObjectMatrix2D other = ((SparseCCObjectMatrix2D)source).getTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0);
            source.forEachNonZero(new IntIntObjectFunction(){

                public Object apply(int i, int j, Object value) {
                    SparseRCObjectMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public ObjectMatrix2D forEachNonZero(IntIntObjectFunction function) {
        int i = this.rows;
        while (--i >= 0) {
            int low = this.rowPointers[i];
            int k = this.rowPointers[i + 1];
            while (--k >= low) {
                int j = this.columnIndexes[k];
                Object value = this.values[k];
                Object r = function.apply(i, j, value);
                if (r == value) continue;
                this.values[k] = r;
            }
        }
        return this;
    }

    public SparseCCObjectMatrix2D getColumnCompressed() {
        SparseRCObjectMatrix2D tr = this.getTranspose();
        SparseCCObjectMatrix2D cc = new SparseCCObjectMatrix2D(this.rows, this.columns);
        cc.rowIndexes = tr.columnIndexes;
        cc.columnPointers = tr.rowPointers;
        cc.values = tr.values;
        cc.rowIndexesSorted = true;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseObjectMatrix2D getDense() {
        final DenseObjectMatrix2D dense = new DenseObjectMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntObjectFunction(){

            public Object apply(int i, int j, Object value) {
                dense.setQuick(i, j, SparseRCObjectMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    public synchronized Object getQuick(int row, int column) {
        int k = SparseRCObjectMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        Object v = 0;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCObjectMatrix2D getTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        Object[] valuesT = new Object[nnz];
        for (int p = 0; p < nnz; ++p) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
        }
        this.cumsum(rowPointersT, w, this.columns);
        for (int j = 0; j < this.rows; ++j) {
            int high = this.rowPointers[j + 1];
            for (int p = this.rowPointers[j]; p < high; ++p) {
                int n = this.columnIndexes[p];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[q] = this.values[p];
            }
        }
        SparseRCObjectMatrix2D T = new SparseRCObjectMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseRCObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    public void removeZeroes() {
        int nz = 0;
        for (int j = 0; j < this.rows; ++j) {
            this.rowPointers[j] = nz;
            for (int p = this.rowPointers[j]; p < this.rowPointers[j + 1]; ++p) {
                if (this.values[p] == null) continue;
                this.values[nz] = this.values[p];
                this.columnIndexes[nz++] = this.columnIndexes[p];
            }
        }
        this.rowPointers[this.rows] = nz;
    }

    public synchronized void setQuick(int row, int column, Object value) {
        int k = SparseRCObjectMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value == null) {
                this.remove(row, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != null) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortColumnIndexes() {
        SparseRCObjectMatrix2D T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int high = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < high; ++j) {
                builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return builder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    private Object cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        double nz2 = 0.0;
        for (int k = 0; k < n; ++k) {
            p[k] = nz;
            nz += c[k];
            nz2 += (double)c[k];
            c[k] = p[k];
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        Object[] valuesNew = new Object[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, Object value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        ObjectArrayList valuesList = new ObjectArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(index, value);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        ObjectArrayList valuesList = new ObjectArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

