/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import cern.colt.matrix.AbstractMatrix;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdcomplex.DComplexFactory1D;
import cern.colt.matrix.tdcomplex.DComplexFactory2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class MatrixMarketUtils {
    private static int i;
    private static int j;
    private static int[] row;
    private static int[] col;
    private static double[] data;
    private static double[] dataR;
    private static double[] dataI;
    private static FileReader fileReader;
    private static MatrixVectorReader reader;
    private static MatrixInfo info;
    private static MatrixSize size;
    private static AbstractMatrix m;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractMatrix readMatrix(String fileName) {
        try {
            fileReader = new FileReader(fileName);
            reader = new MatrixVectorReader(fileReader);
            info = reader.readMatrixInfo();
            size = reader.readMatrixSize(info);
            data = new double[size.numEntries()];
            dataR = new double[size.numEntries()];
            dataI = new double[size.numEntries()];
            row = new int[size.numEntries()];
            col = new int[size.numEntries()];
            if (info.isArray()) {
                if (info.isComplex()) {
                    try {
                        reader.readArray(dataR, dataI);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (info.isDense()) {
                        m = DComplexFactory1D.dense.make(size.numEntries());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((DenseDComplexMatrix1D)m).setQuick(i, dataR[i], dataI[i]);
                        }
                    } else {
                        if (!info.isSparse()) throw new UnsupportedOperationException();
                        m = DComplexFactory1D.sparse.make(size.numEntries());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((SparseDComplexMatrix1D)m).setQuick(i, dataR[i], dataI[i]);
                        }
                    }
                } else {
                    reader.readArray(data);
                    if (size.numRows() == 1 || size.numColumns() == 1) {
                        if (info.isDense()) {
                            m = DoubleFactory1D.dense.make(size.numEntries());
                            for (i = 0; i < size.numEntries(); ++i) {
                                ((DenseDoubleMatrix1D)m).setQuick(i, data[i]);
                            }
                        } else {
                            if (!info.isSparse()) throw new UnsupportedOperationException();
                            m = DoubleFactory1D.sparse.make(size.numEntries());
                            for (i = 0; i < size.numEntries(); ++i) {
                                ((SparseDoubleMatrix1D)m).setQuick(i, data[i]);
                            }
                        }
                    } else if (info.isDense()) {
                        m = DoubleFactory2D.dense.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numColumns(); ++i) {
                            for (j = 0; j < size.numRows(); ++j) {
                                ((DenseDoubleMatrix2D)m).setQuick(j, i, data[i * size.numRows() + j]);
                            }
                        }
                    } else {
                        if (!info.isSparse()) throw new UnsupportedOperationException();
                        m = DoubleFactory2D.sparse.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numColumns(); ++i) {
                            for (j = 0; j < size.numRows(); ++j) {
                                ((SparseDoubleMatrix2D)m).setQuick(j, i, data[i * size.numRows() + j]);
                            }
                        }
                    }
                }
            } else {
                if (!info.isCoordinate()) throw new UnsupportedOperationException();
                if (info.isComplex()) {
                    reader.readCoordinate(row, col, dataR, dataI);
                    if (info.isDense()) {
                        m = DComplexFactory2D.dense.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((DenseDComplexMatrix2D)m).setQuick(row[i], col[i], dataR[i], dataI[i]);
                            if (!info.isSymmetric()) continue;
                            ((DenseDComplexMatrix2D)m).setQuick(col[i], row[i], dataR[i], dataI[i]);
                        }
                    } else {
                        if (!info.isSparse()) throw new UnsupportedOperationException();
                        m = DComplexFactory2D.sparse.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((SparseDComplexMatrix2D)m).setQuick(row[i], col[i], dataR[i], dataI[i]);
                            if (!info.isSymmetric()) continue;
                            ((SparseDComplexMatrix2D)m).setQuick(col[i], row[i], dataR[i], dataI[i]);
                        }
                    }
                } else {
                    reader.readCoordinate(row, col, data);
                    if (info.isDense()) {
                        m = DoubleFactory2D.dense.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((DenseDoubleMatrix2D)m).setQuick(row[i], col[i], data[i]);
                            if (!info.isSymmetric()) continue;
                            ((DenseDoubleMatrix2D)m).setQuick(col[i], row[i], data[i]);
                        }
                    } else {
                        if (!info.isSparse()) throw new UnsupportedOperationException();
                        m = DoubleFactory2D.sparse.make(size.numRows(), size.numColumns());
                        for (i = 0; i < size.numEntries(); ++i) {
                            ((SparseDoubleMatrix2D)m).setQuick(row[i], col[i], data[i]);
                            if (!info.isSymmetric()) continue;
                            ((SparseDoubleMatrix2D)m).setQuick(col[i], row[i], data[i]);
                        }
                    }
                }
            }
            fileReader.close();
            reader.close();
            return m;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return m;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static AbstractMatrix readMatrix(File file) {
        return MatrixMarketUtils.readMatrix(file.getAbsolutePath());
    }
}

