/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.ref.FloatHistogram;

abstract class FloatAbstractHistogram3D
extends FloatHistogram
implements FloatIHistogram3D {
    private static final long serialVersionUID = 1L;
    protected FloatIAxis xAxis;
    protected FloatIAxis yAxis;
    protected FloatIAxis zAxis;

    FloatAbstractHistogram3D(String title) {
        super(title);
    }

    public int allEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int dimensions() {
        return 3;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(float x, float y, float z) {
        this.fill(x, y, z, 1.0f);
    }

    protected abstract FloatIHistogram2D internalSliceXY(String var1, int var2, int var3);

    protected abstract FloatIHistogram2D internalSliceXZ(String var1, int var2, int var3);

    protected abstract FloatIHistogram2D internalSliceYZ(String var1, int var2, int var3);

    int mapX(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapY(int index) {
        int bins = this.yAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapZ(int index) {
        int bins = this.zAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public int[] minMaxBins() {
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        int minBinX = -1;
        int minBinY = -1;
        int minBinZ = -1;
        int maxBinX = -1;
        int maxBinY = -1;
        int maxBinZ = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            int j = this.yAxis.bins();
            while (--j >= 0) {
                int k = this.zAxis.bins();
                while (--k >= 0) {
                    float value = this.binHeight(i, j, k);
                    if (value < minValue) {
                        minValue = value;
                        minBinX = i;
                        minBinY = j;
                        minBinZ = k;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxBinX = i;
                    maxBinY = j;
                    maxBinZ = k;
                }
            }
        }
        int[] result = new int[]{minBinX, minBinY, minBinZ, maxBinX, maxBinY, maxBinZ};
        return result;
    }

    public FloatIHistogram2D projectionXY() {
        String newTitle = this.title() + " (projectionXY)";
        return this.internalSliceXY(newTitle, this.mapZ(-2), this.mapZ(-1));
    }

    public FloatIHistogram2D projectionXZ() {
        String newTitle = this.title() + " (projectionXZ)";
        return this.internalSliceXZ(newTitle, this.mapY(-2), this.mapY(-1));
    }

    public FloatIHistogram2D projectionYZ() {
        String newTitle = this.title() + " (projectionYZ)";
        return this.internalSliceYZ(newTitle, this.mapX(-2), this.mapX(-1));
    }

    public FloatIHistogram2D sliceXY(int indexZ) {
        return this.sliceXY(indexZ, indexZ);
    }

    public FloatIHistogram2D sliceXY(int indexZ1, int indexZ2) {
        int start = this.mapZ(indexZ1);
        int stop = this.mapZ(indexZ2);
        String newTitle = this.title() + " (sliceXY [" + indexZ1 + ":" + indexZ2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    public FloatIHistogram2D sliceXZ(int indexY) {
        return this.sliceXZ(indexY, indexY);
    }

    public FloatIHistogram2D sliceXZ(int indexY1, int indexY2) {
        int start = this.mapY(indexY1);
        int stop = this.mapY(indexY2);
        String newTitle = this.title() + " (sliceXZ [" + indexY1 + ":" + indexY2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    public FloatIHistogram2D sliceYZ(int indexX) {
        return this.sliceYZ(indexX, indexX);
    }

    public FloatIHistogram2D sliceYZ(int indexX1, int indexX2) {
        int start = this.mapX(indexX1);
        int stop = this.mapX(indexX2);
        String newTitle = this.title() + " (sliceYZ [" + indexX1 + ":" + indexX2 + "])";
        return this.internalSliceYZ(newTitle, start, stop);
    }

    public float sumAllBinHeights() {
        float n = 0.0f;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    public float sumBinHeights() {
        float n = 0.0f;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    public float sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public FloatIAxis xAxis() {
        return this.xAxis;
    }

    public FloatIAxis yAxis() {
        return this.yAxis;
    }

    public FloatIAxis zAxis() {
        return this.zAxis;
    }
}

