/*
 * Decompiled with CFR 0.152.
 */
package briefj;

import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BriefFiles {
    public static List<File> ls(File basePath) {
        return BriefFiles.ls(basePath, "");
    }

    public static List<File> ls(File basePath, String suffixFilter) {
        FilenameFilter filter;
        FilenameFilter filenameFilter = filter = suffixFilter == null || suffixFilter.equals("") ? new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return true;
            }
        } : BriefFiles.suffixFilter(suffixFilter);
        if (!basePath.isDirectory()) {
            throw new RuntimeException("Directory does not exists:" + basePath);
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File item : basePath.listFiles(filter)) {
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public static void createParentDirs(File file) {
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FilenameFilter suffixFilter(final String ... suffixesWithoutPeriod) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String file) {
                if (suffixesWithoutPeriod == null || suffixesWithoutPeriod.equals("")) {
                    return true;
                }
                for (String suffixWithoutPeriod : suffixesWithoutPeriod) {
                    if (!file.toUpperCase().matches(".*[.]" + suffixWithoutPeriod.toUpperCase() + "$")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static File createTempFile() {
        return BriefFiles.createTempFile("temp");
    }

    public static File createTempFile(String suffix) {
        try {
            File result = File.createTempFile("Briefj-" + System.currentTimeMillis(), "." + suffix);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File currentDirectory() {
        try {
            return new File("").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File findFileInParents(File currentDir, String fileName) {
        File potential = new File(currentDir = currentDir.getAbsoluteFile(), fileName);
        if (potential.exists()) {
            return potential;
        }
        File parent = currentDir.getParentFile();
        if (parent == null) {
            return null;
        }
        return BriefFiles.findFileInParents(parent, fileName);
    }

    public static File findFileInParents(String fileName) {
        return BriefFiles.findFileInParents(BriefFiles.currentDirectory(), fileName);
    }
}

