/*
 * Decompiled with CFR 0.152.
 */
package briefj.repo;

import briefj.BriefLists;
import briefj.repo.VersionControlRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitRepository
implements VersionControlRepository {
    private final Repository repository;

    public static GitRepository fromLocal(File localFile) {
        try {
            File location = GitRepository.findGitRoot(localFile);
            FileRepository repository = new FileRepository(new File(location, ".git"));
            return new GitRepository((Repository)repository);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File findGitRoot(File location) {
        File gitHidden;
        if (location.isDirectory() && (gitHidden = new File(location, ".git")).exists()) {
            return location;
        }
        if (location.getParentFile() == null) {
            return null;
        }
        return GitRepository.findGitRoot(location.getParentFile());
    }

    public long commitTime(String commitId) {
        try {
            Git git = new Git(this.repository);
            for (RevCommit commit : git.log().call()) {
                if (!commit.getId().name().equals(commitId.toLowerCase())) continue;
                long secs = commit.getCommitTime();
                return secs * 1000L;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException();
    }

    public GitRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public String getLocalAddress() {
        return this.repository.getDirectory().getParentFile().getAbsolutePath();
    }

    @Override
    public List<String> getRemoteAddresses() {
        ArrayList result = Lists.newArrayList();
        StoredConfig storedConfig = this.repository.getConfig();
        ArrayList remotes = Lists.newArrayList((Iterable)storedConfig.getSubsections("remote"));
        Collections.sort(remotes);
        for (String remoteName : remotes) {
            String url = storedConfig.getString("remote", remoteName, "url");
            result.add(url);
        }
        return result;
    }

    @Override
    public String getCommitIdentifier() {
        try {
            return this.repository.resolve("HEAD").getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String cloneScript() {
        return "#!/bin/bash\ngit clone " + this.getLocalAddress() + "\n" + "git checkout " + this.getCommitIdentifier();
    }

    @Override
    public List<File> dirtyFiles() {
        try {
            Status status = new Git(this.repository).status().call();
            HashSet fileNames = Sets.newHashSet();
            fileNames.addAll(status.getAdded());
            fileNames.addAll(status.getChanged());
            fileNames.addAll(status.getConflicting());
            fileNames.addAll(status.getMissing());
            fileNames.addAll(status.getModified());
            fileNames.addAll(status.getRemoved());
            fileNames.addAll(status.getUntracked());
            ArrayList result = Lists.newArrayList();
            for (String fileName : BriefLists.sort(fileNames)) {
                result.add(new File(fileName));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

