/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo.decomposition;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.SparseCCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_happly;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_ipvec;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_pvec;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_qr;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_sqr;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_usolve;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_utsolve;

public class SparseDComplexQRDecomposition {
    private DZcs_common.DZcss S;
    private DZcs_common.DZcsn N;
    private DComplexMatrix2D R;
    private DComplexMatrix2D V;
    private int m;
    private int n;
    private boolean rcMatrix = false;

    public SparseDComplexQRDecomposition(DComplexMatrix2D A, int order) {
        DZcs_common.DZcs dcs;
        DComplexProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.m = A.rows();
        this.n = A.columns();
        if (A instanceof SparseRCDComplexMatrix2D) {
            this.rcMatrix = true;
            dcs = this.m >= this.n ? ((SparseRCDComplexMatrix2D)A).getColumnCompressed().elements() : ((SparseRCDComplexMatrix2D)A).getColumnCompressed().getTranspose().elements();
        } else {
            dcs = this.m >= this.n ? (DZcs_common.DZcs)A.elements() : ((SparseCCDComplexMatrix2D)A).getTranspose().elements();
        }
        this.S = DZcs_sqr.cs_sqr((int)order, (DZcs_common.DZcs)dcs, (boolean)true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = DZcs_qr.cs_qr((DZcs_common.DZcs)dcs, (DZcs_common.DZcss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public DComplexMatrix2D getV() {
        if (this.V == null) {
            this.V = new SparseCCDComplexMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.V = ((SparseCCDComplexMatrix2D)this.V).getRowCompressed();
            }
        }
        return this.V.copy();
    }

    public double[] getBeta() {
        if (this.N.B == null) {
            return null;
        }
        double[] beta = new double[this.N.B.length];
        System.arraycopy(this.N.B, 0, beta, 0, this.N.B.length);
        return beta;
    }

    public DComplexMatrix2D getR() {
        if (this.R == null) {
            this.R = new SparseCCDComplexMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDComplexMatrix2D)this.R).getRowCompressed();
            }
        }
        return this.R.copy();
    }

    public DZcs_common.DZcss getSymbolicAnalysis() {
        DZcs_common.DZcss S2 = new DZcs_common.DZcss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean hasFullRank() {
        if (this.R == null) {
            this.R = new SparseCCDComplexMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDComplexMatrix2D)this.R).getRowCompressed();
            }
        }
        int mn = Math.min(this.m, this.n);
        for (int j = 0; j < mn; ++j) {
            double[] jj = this.R.getQuick(j, j);
            if (jj[0] != 0.0 || jj[1] != 0.0) continue;
            return false;
        }
        return true;
    }

    public void solve(DComplexMatrix1D b) {
        if (b.size() != (long)Math.max(this.m, this.n)) {
            throw new IllegalArgumentException("The size b must be equal to max(A.rows(), A.columns()).");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        DZcs_common.DZcsa x = b.isView() ? new DZcs_common.DZcsa((double[])b.copy().elements()) : new DZcs_common.DZcsa((double[])b.elements());
        if (this.m >= this.n) {
            DZcs_common.DZcsa y = new DZcs_common.DZcsa(this.S != null ? this.S.m2 : 1);
            DZcs_ipvec.cs_ipvec((int[])this.S.pinv, (DZcs_common.DZcsa)x, (DZcs_common.DZcsa)y, (int)this.m);
            for (int k = 0; k < this.n; ++k) {
                DZcs_happly.cs_happly((DZcs_common.DZcs)this.N.L, (int)k, (double)this.N.B[k], (DZcs_common.DZcsa)y);
            }
            DZcs_usolve.cs_usolve((DZcs_common.DZcs)this.N.U, (DZcs_common.DZcsa)y);
            DZcs_ipvec.cs_ipvec((int[])this.S.q, (DZcs_common.DZcsa)y, (DZcs_common.DZcsa)x, (int)this.n);
        } else {
            DZcs_common.DZcsa y = new DZcs_common.DZcsa(this.S != null ? this.S.m2 : 1);
            DZcs_pvec.cs_pvec((int[])this.S.q, (DZcs_common.DZcsa)x, (DZcs_common.DZcsa)y, (int)this.m);
            DZcs_utsolve.cs_utsolve((DZcs_common.DZcs)this.N.U, (DZcs_common.DZcsa)y);
            for (int k = this.m - 1; k >= 0; --k) {
                DZcs_happly.cs_happly((DZcs_common.DZcs)this.N.L, (int)k, (double)this.N.B[k], (DZcs_common.DZcsa)y);
            }
            DZcs_pvec.cs_pvec((int[])this.S.pinv, (DZcs_common.DZcsa)y, (DZcs_common.DZcsa)x, (int)this.n);
        }
    }
}

