/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix2D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix2D.txt";
    private static double[][] a_2d;
    private static double[][] b_2d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix2D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int c;
        int r;
        BenchmarkMatrixKernel.readSettings2D();
        Random rand = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        a_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        a_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        int idx = 0;
        for (r = 0; r < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++r) {
            for (c = 0; c < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++c) {
                BenchmarkDenseDComplexMatrix2D.a_2d[r][c] = rand.nextDouble();
                BenchmarkDenseDComplexMatrix2D.a_1d[idx++] = a_2d[r][c];
            }
        }
        b_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        b_2d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        idx = 0;
        for (r = 0; r < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++r) {
            for (c = 0; c < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++c) {
                BenchmarkDenseDComplexMatrix2D.b_2d[r][c] = rand.nextDouble();
                BenchmarkDenseDComplexMatrix2D.b_1d[idx++] = b_2d[r][c];
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_2D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_2D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_2d = null;
        b_1d = null;
        b_2d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix2D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix2D)A).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix2DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix2D B = new DenseDComplexMatrix2D(b_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix2D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix2D)A).aggregate(B, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DComplexMatrix2D Bv = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.aggregate(Bv, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "aggregate(DComplexMatrix2D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        double value = Math.random();
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(value, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(value, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(value, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(a_1d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(a_1d);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a_1d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a_1d);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArray() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(a_2d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(a_2d);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a_2d);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a_2d);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(double[][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(DComplexFunctions.acos);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(DComplexFunctions.acos);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                Av.assign(DComplexFunctions.acos);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix2D() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DenseDComplexMatrix2D B = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(B);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(B);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DComplexMatrix2D Av = A.viewDice();
        B = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D Bv = B.viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(Bv);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix2DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix2D B = new DenseDComplexMatrix2D(b_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(B, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(B, DComplexFunctions.div);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        DComplexMatrix2D Bv = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(Bv, DComplexFunctions.div);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                Av.assign(Bv, DComplexFunctions.div);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexMatrix2D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        double[] value = new double[]{-1.0, -2.0};
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(procedure, value);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, value);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                Av.assign(procedure, value);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        DComplexProcedure procedure = new DComplexProcedure(){

            public boolean apply(double[] element) {
                return DComplex.abs(element) > 0.1;
            }
        };
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(procedure, DComplexFunctions.tan);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                Av.assign(procedure, DComplexFunctions.tan);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int i;
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        float[] a_1d_float = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        for (i = 0; i < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++i) {
            a_1d_float[i] = (float)Math.random();
        }
        i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).assign(a_1d_float);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).assign(a_1d_float);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.assign(a_1d_float);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(0.0, 0.0);
                t.reset().start();
                Av.assign(a_1d_float);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            int card = ((DComplexMatrix2D)A).cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = ((DComplexMatrix2D)A).cardinality();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D Av = A.viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            int card = Av.cardinality();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                card = Av.cardinality();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.fft2();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.fft2();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).fft2();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).fft2();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftColumns() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.fftColumns();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.fftColumns();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).fftColumns();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).fftColumns();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fftColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftRows() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.fftRows();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.fftRows();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).fftRows();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).fftRows();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "fftRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testForEachNonZero() {
        IntIntDComplexFunction function = new IntIntDComplexFunction(){

            public double[] apply(int first, int second, double[] third) {
                return DComplex.sqrt(third);
            }
        };
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).forEachNonZero(function);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)A).assign(a_2d);
                t.reset().start();
                ((DComplexMatrix2D)A).forEachNonZero(function);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(a_2d).viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.forEachNonZero(function);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                Av.forEachNonZero(function);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "forEachNonZero(IntIntDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetConjugateTranspose() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DComplexMatrix2D B = ((DComplexMatrix2D)A).getConjugateTranspose();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix2D)A).getConjugateTranspose();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DComplexMatrix2D Bv = Av.getConjugateTranspose();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Bv = Av.getConjugateTranspose();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getConjugateTranspose()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix2D B = ((DComplexMatrix2D)A).getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix2D)A).getRealPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix2D Bv = Av.getRealPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Bv = Av.getRealPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DoubleMatrix2D B = ((DComplexMatrix2D)A).getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix2D)A).getImaginaryPart();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DoubleMatrix2D Bv = Av.getImaginaryPart();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                Bv = Av.getImaginaryPart();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListArrayList() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        IntArrayList rowList = new IntArrayList();
        IntArrayList colList = new IntArrayList();
        ArrayList<double[]> valueList = new ArrayList<double[]>();
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).getNonZeros(rowList, colList, valueList);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                rowList.clear();
                colList.clear();
                valueList.clear();
                t.reset().start();
                ((DComplexMatrix2D)A).getNonZeros(rowList, colList, valueList);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(a_2d).viewDice();
        rowList.clear();
        colList.clear();
        valueList.clear();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.getNonZeros(rowList, colList, valueList);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                rowList.clear();
                colList.clear();
                valueList.clear();
                t.reset().start();
                Av.getNonZeros(rowList, colList, valueList);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "getNonZeros(IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.ifft2(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.ifft2(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).ifft2(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).ifft2(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftColumns() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.ifftColumns(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.ifftColumns(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).ifftColumns(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).ifftColumns(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifftColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftRows() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            A.ifftRows(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                A.assign(a_2d);
                t.reset().start();
                A.ifftRows(true);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DenseDComplexMatrix2D)Av).ifftRows(true);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Av.assign(a_2d);
                t.reset().start();
                ((DenseDComplexMatrix2D)Av).ifftRows(true);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "ifftRows(true)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[] aSum = ((DComplexMatrix2D)A).zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = ((DComplexMatrix2D)A).zSum();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[] aSum = Av.zSum();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                aSum = Av.zSum();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            double[][] array = ((DComplexMatrix2D)A).toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = ((DComplexMatrix2D)A).toArray();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            double[][] array = Av.toArray();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                array = Av.toArray();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            DComplexMatrix1D B = ((DComplexMatrix2D)A).vectorize();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = ((DComplexMatrix2D)A).vectorize();
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            DComplexMatrix1D B = Av.vectorize();
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                t.reset().start();
                B = Av.vectorize();
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDComplexMatrix1DDComplexMatrix1DDoubleArrayDoubleArrayBoolean() {
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        DenseDComplexMatrix1D y = new DenseDComplexMatrix1D(A.columns());
        double[] alpha = new double[]{3.0, 4.0};
        double[] beta = new double[]{5.0, 6.0};
        int i = 0;
        while ((long)i < y.size()) {
            y.set(i, new double[]{Math.random(), Math.random()});
            ++i;
        }
        DenseDComplexMatrix1D z = new DenseDComplexMatrix1D(A.rows());
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            ((DComplexMatrix2D)A).zMult(y, z, alpha, beta, false);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)z).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).zMult(y, z, alpha, beta, false);
                t.stop();
                int n = i2;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i2++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix2D Av = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int i3 = 0;
        while (i3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i3]);
            Av.zMult(y, z, alpha, beta, false);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix1D)z).assign(0.0, 0.0);
                t.reset().start();
                Av.zMult(y, z, alpha, beta, false);
                t.stop();
                int n = i3;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i3++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zMult(DComplexMatrix1D, DComplexMatrix1D, double[], double[], boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultDComplexMatrix2DDComplexMatrix2DDoubleArrayDoubleArrayBooleanBoolean() {
        int oldNiters = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseDComplexMatrix2D A = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D B = new DenseDComplexMatrix2D(b_2d);
        B = B.viewDice().copy();
        DenseDComplexMatrix2D C = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        double[] alpha = new double[]{3.0, 4.0};
        double[] beta = new double[]{5.0, 6.0};
        int i = 0;
        while (i < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i]);
            ((DComplexMatrix2D)A).zMult(B, C, alpha, beta, false, false);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                ((DComplexMatrix2D)C).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix2D)A).zMult(B, C, alpha, beta, false, false);
                t.stop();
                int n = i;
                noViewTimes[n] = noViewTimes[n] + t.millis();
            }
            int n = i++;
            noViewTimes[n] = noViewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        A = new DenseDComplexMatrix2D(a_2d);
        DComplexMatrix2D Av = A.viewDice();
        B = new DenseDComplexMatrix2D(b_2d);
        B = B.viewDice().copy();
        DComplexMatrix2D Bv = B.viewDice();
        C = new DenseDComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DComplexMatrix2D Cv = C.viewDice();
        int i2 = 0;
        while (i2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[i2]);
            Av.zMult(Bv, Cv, alpha, beta, false, false);
            for (int j = 0; j < BenchmarkMatrixKernel.NITERS; ++j) {
                Cv.assign(0.0, 0.0);
                t.reset().start();
                Av.zMult(Bv, Cv, alpha, beta, false, false);
                t.stop();
                int n = i2;
                viewTimes[n] = viewTimes[n] + t.millis();
            }
            int n = i2++;
            viewTimes[n] = viewTimes[n] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String method = "zMult(DComplexMatrix2D, DComplexMatrix2D, double[], double[], boolean, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(method, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = oldNiters;
    }
}

