/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleMatrix1DComparator;
import cern.colt.matrix.tdouble.algo.DoubleMatrix2DComparator;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DRand;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DoubleBinFunctions1D;

public class DoubleSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DoubleSorting quickSort = new DoubleSorting();
    public static final DoubleSorting mergeSort = new DoubleSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected DoubleSorting() {
    }

    private static final int compareNaN(double a, double b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.parallelQuickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public DoubleMatrix1D sort(DoubleMatrix1D vector) {
        return vector.viewSelection(this.sortIndex(vector));
    }

    public int[] sortIndex(final DoubleMatrix1D vector) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseDoubleMatrix1D) {
            final double[] velems = (double[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    double av = velems[idxa];
                    double bv = velems[idxb];
                    if (av != av || bv != bv) {
                        return DoubleSorting.compareNaN(av, bv);
                    }
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    double av = vector.getQuick(a);
                    double bv = vector.getQuick(b);
                    if (av != av || bv != bv) {
                        return DoubleSorting.compareNaN(av, bv);
                    }
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public int[] sortIndex(DoubleMatrix1D vector, IntComparator comp) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public DoubleMatrix1D sort(DoubleMatrix1D vector, DoubleComparator c) {
        return vector.viewSelection(this.sortIndex(vector, c));
    }

    public int[] sortIndex(final DoubleMatrix1D vector, final DoubleComparator c) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseDoubleMatrix1D) {
            final double[] velems = (double[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    return c.compare(velems[idxa], velems[idxb]);
                }
            };
        } else {
            comp = new IntComparator(){

                public int compare(int a, int b) {
                    return c.compare(vector.getQuick(a), vector.getQuick(b));
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final double[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int x, int y) {
                double a = aggregates[x];
                double b = aggregates[y];
                if (a != a || b != b) {
                    return DoubleSorting.compareNaN(a, b);
                }
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                double t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = col.getQuick(a);
                double bv = col.getQuick(b);
                if (av != av || bv != bv) {
                    return DoubleSorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final DoubleMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D[] views = new DoubleMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, DoubleBinFunction1D aggregate) {
        DoubleMatrix2D tmp = matrix.like(1, matrix.rows());
        DoubleBinFunction1D[] func = new DoubleBinFunction1D[]{aggregate};
        DoubleStatistic.aggregate(matrix.viewDice(), func, tmp);
        double[] aggr = tmp.viewRow(0).toArray();
        return this.sort(matrix, aggr);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = sliceView.getQuick(a);
                double bv = sliceView.getQuick(b);
                if (av != av || bv != bv) {
                    return DoubleSorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, final DoubleMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix2D[] views = new DoubleMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public static void zdemo1() {
        DoubleSorting sort = quickSort;
        DoubleMatrix2D matrix = DoubleFactory2D.dense.descending(4, 3);
        DoubleMatrix1DComparator comp = new DoubleMatrix1DComparator(){

            public int compare(DoubleMatrix1D a, DoubleMatrix1D b) {
                double bs;
                double as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo2() {
        DoubleSorting sort = quickSort;
        DoubleMatrix3D matrix = DoubleFactory3D.dense.descending(4, 3, 2);
        DoubleMatrix2DComparator comp = new DoubleMatrix2DComparator(){

            public int compare(DoubleMatrix2D a, DoubleMatrix2D b) {
                double bs;
                double as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo3() {
        DoubleSorting sort = quickSort;
        double[] values = new double[]{0.5, 1.5, 2.5, 3.5};
        DenseDoubleMatrix1D matrix = new DenseDoubleMatrix1D(values);
        DoubleComparator comp = new DoubleComparator(){

            public int compare(double a, double b) {
                double bs;
                double as = Math.sin(a);
                return as < (bs = Math.sin(b)) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        DoubleMatrix1D sorted = sort.sort(matrix, comp);
        System.out.println("sorted  :" + sorted);
        sorted.assign(DoubleFunctions.sin);
        System.out.println("sined  :" + sorted);
    }

    protected static void zdemo4() {
        double[] values1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] values2 = new double[]{0.0, 2.0, 4.0, 6.0};
        DenseDoubleMatrix1D matrix1 = new DenseDoubleMatrix1D(values1);
        DenseDoubleMatrix1D matrix2 = new DenseDoubleMatrix1D(values2);
        System.out.println("m1:" + matrix1);
        System.out.println("m2:" + matrix2);
        ((DoubleMatrix1D)matrix1).assign(matrix2, DoubleFunctions.pow);
        System.out.println("applied:" + matrix1);
    }

    public static void zdemo5(int rows, int columns, boolean print) {
        DoubleSorting sort = quickSort;
        System.out.println("\n\n");
        System.out.print("now initializing... ");
        Timer timer = new Timer().start();
        DoubleFunctions F = DoubleFunctions.functions;
        DoubleMatrix2D A = DoubleFactory2D.dense.make(rows, columns);
        A.assign(new DRand());
        timer.stop().display();
        DoubleMatrix2D B = A.like();
        timer.reset().start();
        System.out.print("now copying... ");
        B.assign(A);
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying subrange... ");
        B.viewPart(0, 0, rows, columns).assign(A.viewPart(0, 0, rows, columns));
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying selected... ");
        B.viewSelection(null, null).assign(A.viewSelection(null, null));
        timer.stop().display();
        System.out.print("now sorting - quick version with precomputation... ");
        timer.reset().start();
        A = sort.sort(A, DoubleBinFunctions1D.median);
        timer.stop().display();
        if (print) {
            int r = Math.min(rows, 5);
            DoubleBinFunction1D[] funs = new DoubleBinFunction1D[]{DoubleBinFunctions1D.median, DoubleBinFunctions1D.sumLog, DoubleBinFunctions1D.geometricMean};
            String[] rowNames = new String[r];
            String[] columnNames = new String[columns];
            int i = columns;
            while (--i >= 0) {
                columnNames[i] = Integer.toString(i);
            }
            i = r;
            while (--i >= 0) {
                rowNames[i] = Integer.toString(i);
            }
            System.out.println("first part of sorted result = \n" + new DoubleFormatter("%G").toTitleString(A.viewPart(0, 0, r, columns), rowNames, columnNames, null, null, null, funs));
        }
        System.out.print("now sorting - slow version... ");
        A = B;
        DoubleMatrix1DComparator fun = new DoubleMatrix1DComparator(){

            public int compare(DoubleMatrix1D x, DoubleMatrix1D y) {
                double b;
                double a = DoubleStatistic.bin(x).median();
                return a < (b = DoubleStatistic.bin(y).median()) ? -1 : (a == b ? 0 : 1);
            }
        };
        timer.reset().start();
        A = sort.sort(A, fun);
        timer.stop().display();
    }

    public static void zdemo6() {
        double[][] values = new double[][]{{3.0, 7.0, 0.0}, {2.0, 1.0, 0.0}, {2.0, 2.0, 0.0}, {1.0, 8.0, 0.0}, {2.0, 5.0, 0.0}, {7.0, 0.0, 0.0}, {2.0, 3.0, 0.0}, {1.0, 0.0, 0.0}, {4.0, 0.0, 0.0}, {2.0, 0.0, 0.0}};
        DoubleMatrix2D A = DoubleFactory2D.dense.make(values);
        System.out.println("\n\nunsorted:" + A);
        DoubleMatrix2D B = quickSort.sort(A, 1);
        DoubleMatrix2D C = quickSort.sort(B, 0);
        System.out.println("quick sorted  :" + C);
        B = mergeSort.sort(A, 1);
        C = mergeSort.sort(B, 0);
        System.out.println("merge sorted  :" + C);
    }

    public static void zdemo7(int rows, int columns, boolean print) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        DoubleFunctions F = DoubleFunctions.functions;
        DoubleMatrix2D A = DoubleFactory2D.dense.make(rows, columns);
        A.assign(new DRand());
        double[] v1 = A.viewColumn(0).toArray();
        double[] v2 = A.viewColumn(0).toArray();
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now quick sorting with simple aggregation... ");
        timer.reset().start();
        quickSort.sort(A, v1);
        timer.stop().display();
        System.out.print("now merge sorting with simple aggregation... ");
        timer.reset().start();
        mergeSort.sort(A, v2);
        timer.stop().display();
    }

    public static void zdemo8(int size) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        DoubleFunctions F = DoubleFunctions.functions;
        DoubleMatrix1D A = DoubleFactory1D.dense.random(size);
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(A);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(A);
        timer.stop().display();
    }

    public static void main(String[] args) {
        ConcurrencyUtils.setNumberOfThreads(2);
        DoubleSorting.zdemo8(10000000);
        System.exit(0);
    }
}

