/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    private DoubleFFT_1D fft;
    private DoubleDCT_1D dct;
    private DoubleDST_1D dst;
    private DoubleDHT_1D dht;
    protected double[] elements;

    public DenseDoubleMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseDoubleMatrix1D(int size) {
        this.setUp(size);
        this.elements = new double[size];
    }

    public DenseDoubleMatrix1D(int size, double[] elements, int zero, int stride, boolean isView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = this.size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int idx = DenseDoubleMatrix1D.this.zero + (firstIdx - 1) * DenseDoubleMatrix1D.this.stride;
                        double a = f.apply(DenseDoubleMatrix1D.this.elements[idx]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseDoubleMatrix1D.this.elements[idx -= DenseDoubleMatrix1D.this.stride]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + (this.size - 1) * this.stride;
            a = f.apply(this.elements[idx]);
            int i = this.size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[idx -= this.stride]));
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int idx = DenseDoubleMatrix1D.this.zero + indexElements[firstIdx] * DenseDoubleMatrix1D.this.stride;
                        double a = f.apply(DenseDoubleMatrix1D.this.elements[idx]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            idx = DenseDoubleMatrix1D.this.zero + indexElements[i] * DenseDoubleMatrix1D.this.stride;
                            double elem = DenseDoubleMatrix1D.this.elements[idx];
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + indexElements[0] * this.stride;
            a = f.apply(this.elements[idx]);
            for (int i = 1; i < size; ++i) {
                idx = this.zero + indexElements[i] * this.stride;
                double elem = this.elements[idx];
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public double aggregate(DoubleMatrix1D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        if (!(other instanceof DenseDoubleMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            return Double.NaN;
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final double[] elementsOther = (double[])other.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        double a = f.apply(DenseDoubleMatrix1D.this.elements[idx], elementsOther[idxOther]);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DenseDoubleMatrix1D.this.elements[idx += DenseDoubleMatrix1D.this.stride], elementsOther[idxOther += strideOther]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero], elementsOther[zeroOther]);
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride], elementsOther[idxOther += strideOther]));
            }
        }
        return a;
    }

    public DoubleMatrix1D assign(final DoubleFunction function) {
        int nthreads;
        double multiplicator;
        if (function instanceof DoubleMult) {
            multiplicator = ((DoubleMult)function).multiplicator;
            if (multiplicator == 1.0) {
                return this;
            }
        } else {
            multiplicator = 0.0;
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        if (function instanceof DoubleMult) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                int n = idx;
                                DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] * multiplicator;
                                idx += DenseDoubleMatrix1D.this.stride;
                            }
                        } else {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                DenseDoubleMatrix1D.this.elements[idx] = function.apply(DenseDoubleMatrix1D.this.elements[idx]);
                                idx += DenseDoubleMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero - this.stride;
            if (function instanceof DoubleMult) {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = this.elements[idx] * multiplicator;
                }
            } else {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = function.apply(this.elements[idx]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final DoubleFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (cond.apply(DenseDoubleMatrix1D.this.elements[idx])) {
                                DenseDoubleMatrix1D.this.elements[idx] = function.apply(DenseDoubleMatrix1D.this.elements[idx]);
                            }
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = function.apply(this.elements[idx]);
                }
                idx += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (cond.apply(DenseDoubleMatrix1D.this.elements[idx])) {
                                DenseDoubleMatrix1D.this.elements[idx] = value;
                            }
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = value;
                }
                idx += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double value) {
        final double[] elems = this.elements;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            elems[idx] = value;
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                elems[idx] = value;
                idx += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(final double[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DenseDoubleMatrix1D.this.elements[idx] = values[i];
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[idx] = values[i];
                idx += this.stride;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D source) {
        if (!(source instanceof DenseDoubleMatrix1D)) {
            super.assign(source);
            return this;
        }
        DenseDoubleMatrix1D other = (DenseDoubleMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DoubleMatrix1D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix1D)) {
                super.assign(source);
                return this;
            }
            other = (DenseDoubleMatrix1D)c;
        }
        final double[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            DenseDoubleMatrix1D.this.elements[idx] = elementsOther[idxOther];
                            idx += DenseDoubleMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                this.elements[idx] = elementsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D y, final DoubleDoubleFunction function) {
        if (!(y instanceof DenseDoubleMatrix1D)) {
            super.assign(y, function);
            return this;
        }
        this.checkSize(y);
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        final double[] elementsOther = (double[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == DoubleFunctions.mult) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                int n = idx;
                                DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] * elementsOther[idxOther];
                                idx += DenseDoubleMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function == DoubleFunctions.div) {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                int n = idx;
                                DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] / elementsOther[idxOther];
                                idx += DenseDoubleMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        } else if (function instanceof DoublePlusMultFirst) {
                            double multiplicator = ((DoublePlusMultFirst)function).multiplicator;
                            if (multiplicator == 0.0) {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    DenseDoubleMatrix1D.this.elements[idx] = elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            } else if (multiplicator == 1.0) {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    int n = idx;
                                    DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] + elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            } else if (multiplicator == -1.0) {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    DenseDoubleMatrix1D.this.elements[idx] = elementsOther[idxOther] - DenseDoubleMatrix1D.this.elements[idx];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            } else {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    DenseDoubleMatrix1D.this.elements[idx] = multiplicator * DenseDoubleMatrix1D.this.elements[idx] + elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            }
                        } else if (function instanceof DoublePlusMultSecond) {
                            double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
                            if (multiplicator == 0.0) {
                                return;
                            }
                            if (multiplicator == 1.0) {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    int n = idx;
                                    DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] + elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            } else if (multiplicator == -1.0) {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    int n = idx;
                                    DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] - elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            } else {
                                for (int k = firstIdx; k < lastIdx; ++k) {
                                    int n = idx;
                                    DenseDoubleMatrix1D.this.elements[n] = DenseDoubleMatrix1D.this.elements[n] + multiplicator * elementsOther[idxOther];
                                    idx += DenseDoubleMatrix1D.this.stride;
                                    idxOther += strideOther;
                                }
                            }
                        } else {
                            for (int k = firstIdx; k < lastIdx; ++k) {
                                DenseDoubleMatrix1D.this.elements[idx] = function.apply(DenseDoubleMatrix1D.this.elements[idx], elementsOther[idxOther]);
                                idx += DenseDoubleMatrix1D.this.stride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == DoubleFunctions.mult) {
                for (int k = 0; k < this.size; ++k) {
                    int n = idx;
                    this.elements[n] = this.elements[n] * elementsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function == DoubleFunctions.div) {
                for (int k = 0; k < this.size; ++k) {
                    int n = idx;
                    this.elements[n] = this.elements[n] / elementsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                }
            } else if (function instanceof DoublePlusMultSecond) {
                double multiplicator = ((DoublePlusMultSecond)function).multiplicator;
                if (multiplicator == 0.0) {
                    return this;
                }
                if (multiplicator == 1.0) {
                    for (int k = 0; k < this.size; ++k) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                    }
                } else if (multiplicator == -1.0) {
                    for (int k = 0; k < this.size; ++k) {
                        int n = idx;
                        this.elements[n] = this.elements[n] - elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                    }
                } else {
                    for (int k = 0; k < this.size; ++k) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + multiplicator * elementsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                    }
                }
            } else {
                for (int k = 0; k < this.size; ++k) {
                    this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                    idx += this.stride;
                    idxOther += strideOther;
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (DenseDoubleMatrix1D.this.elements[idx] != 0.0) {
                                ++cardinality;
                            }
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[idx] != 0.0) {
                    ++cardinality;
                }
                idx += this.stride;
            }
        }
        return cardinality;
    }

    public void dct(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct == null) {
            this.dct = new DoubleDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.forward(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dct.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht == null) {
            this.dht = new DoubleDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.forward(this.elements);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dht.forward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst == null) {
            this.dst = new DoubleDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.forward(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dst.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realForward(this.elements);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.fft.realForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseDComplexMatrix1D getFft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        double[] elems = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix1D c = new DenseDComplexMatrix1D(this.size);
        double[] elementsC = c.elements();
        System.arraycopy(elems, 0, elementsC, 0, this.size);
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        this.fft.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return c;
    }

    public DenseDComplexMatrix1D getIfft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        double[] elems = this.isNoView ? this.elements : (double[])this.copy().elements();
        DenseDComplexMatrix1D c = new DenseDComplexMatrix1D(this.size);
        double[] elementsC = c.elements();
        System.arraycopy(elems, 0, elementsC, 0, this.size);
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        this.fft.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return c;
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            double value = this.elements[idx];
            if (value != 0.0) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        for (int i = rem; i < this.size; i += 2) {
            double value = this.elements[idx];
            if (value != 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) != 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
    }

    public void getPositiveValues(IntArrayList indexList, DoubleArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            double value = this.elements[idx];
            if (value > 0.0) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        for (int i = rem; i < this.size; i += 2) {
            double value = this.elements[idx];
            if (value > 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) > 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
    }

    public void getNegativeValues(IntArrayList indexList, DoubleArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int rem = this.size % 2;
        int idx = this.zero;
        if (rem == 1) {
            double value = this.elements[idx];
            if (value < 0.0) {
                if (fillIndexList) {
                    indexList.add(0);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
        for (int i = rem; i < this.size; i += 2) {
            double value = this.elements[idx];
            if (value < 0.0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            if ((value = this.elements[idx += this.stride]) < 0.0) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            idx += this.stride;
        }
    }

    public double[] getMaxLocation() {
        int location = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        double maxValue = DenseDoubleMatrix1D.this.elements[idx];
                        int location = (idx - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            if (!(maxValue < DenseDoubleMatrix1D.this.elements[idx += DenseDoubleMatrix1D.this.stride])) continue;
                            maxValue = DenseDoubleMatrix1D.this.elements[idx];
                            location = (idx - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        }
                        return new double[]{maxValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(maxValue < this.elements[idx += this.stride])) continue;
                maxValue = this.elements[idx];
                location = (idx - this.zero) / this.stride;
            }
        }
        return new double[]{maxValue, location};
    }

    public double[] getMinLocation() {
        int location = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        double minValue = DenseDoubleMatrix1D.this.elements[idx];
                        int location = (idx - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            if (!(minValue > DenseDoubleMatrix1D.this.elements[idx += DenseDoubleMatrix1D.this.stride])) continue;
                            minValue = DenseDoubleMatrix1D.this.elements[idx];
                            location = (idx - DenseDoubleMatrix1D.this.zero) / DenseDoubleMatrix1D.this.stride;
                        }
                        return new double[]{minValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(minValue > this.elements[idx += this.stride])) continue;
                minValue = this.elements[idx];
                location = (idx - this.zero) / this.stride;
            }
        }
        return new double[]{minValue, location};
    }

    public double getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    public void idct(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct == null) {
            this.dct = new DoubleDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.inverse(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dct.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht == null) {
            this.dht = new DoubleDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.inverse(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dht.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst == null) {
            this.dst = new DoubleDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.inverse(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.dst.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realInverse(this.elements, scale);
        } else {
            DoubleMatrix1D copy = this.copy();
            this.fft.realInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DoubleMatrix1D like(int size) {
        return new DenseDoubleMatrix1D(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseDoubleMatrix2D M = new DenseDoubleMatrix2D(rows, columns);
        final double[] elementsOther = (double[])((DoubleMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idxOther = zeroOther + c * columnStrideOther;
                            int idx = DenseDoubleMatrix1D.this.zero + c * rows * DenseDoubleMatrix1D.this.stride;
                            for (int r = 0; r < rows; ++r) {
                                elementsOther[idxOther] = DenseDoubleMatrix1D.this.elements[idx];
                                idxOther += rowStrideOther;
                                idx += DenseDoubleMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int c = 0; c < columns; ++c) {
                int idxOther = zeroOther + c * columnStrideOther;
                for (int r = 0; r < rows; ++r) {
                    elementsOther[idxOther] = this.elements[idx];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                }
            }
        }
        return M;
    }

    public DoubleMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseDoubleMatrix3D M = new DenseDoubleMatrix3D(slices, rows, columns);
        final double[] elementsOther = (double[])((DoubleMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < columns; ++c) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                                int idx = DenseDoubleMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseDoubleMatrix1D.this.stride;
                                for (int r = 0; r < rows; ++r) {
                                    elementsOther[idxOther] = DenseDoubleMatrix1D.this.elements[idx];
                                    idxOther += rowStrideOther;
                                    idx += DenseDoubleMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            for (int s = 0; s < slices; ++s) {
                for (int c = 0; c < columns; ++c) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                    for (int r = 0; r < rows; ++r) {
                        elementsOther[idxOther] = this.elements[idx];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                    }
                }
            }
        }
        return M;
    }

    public void setQuick(int index, double value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    public void swap(DoubleMatrix1D other) {
        DenseDoubleMatrix1D y;
        if (!(other instanceof DenseDoubleMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseDoubleMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final double[] elementsOther = y.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            double tmp = DenseDoubleMatrix1D.this.elements[idx];
                            DenseDoubleMatrix1D.this.elements[idx] = elementsOther[idxOther];
                            elementsOther[idxOther] = tmp;
                            idx += DenseDoubleMatrix1D.this.stride;
                            idxOther += strideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            for (int k = 0; k < this.size; ++k) {
                double tmp = this.elements[idx];
                this.elements[idx] = elementsOther[idxOther];
                elementsOther[idxOther] = tmp;
                idx += this.stride;
                idxOther += strideOther;
            }
        }
    }

    public void toArray(double[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    public double zDotProduct(DoubleMatrix1D y, int from, int length) {
        if (!(y instanceof DenseDoubleMatrix1D)) {
            return super.zDotProduct(y, from, length);
        }
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        int tail = from + length;
        if (from < 0 || length < 0) {
            return 0.0;
        }
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        final double[] elementsOther = yy.elements;
        int zeroThis = (int)this.index(from);
        int zeroOther = (int)yy.index(from);
        int strideOther = yy.stride;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        double sum = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Double[] results = new Double[nthreads];
            int k = length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseDoubleMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseDoubleMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        double sum = 0.0;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseDoubleMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseDoubleMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseDoubleMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseDoubleMatrix1D.this.elements[n] * elementsOther[n2] + DenseDoubleMatrix1D.this.elements[n3] * elementsOther[n4] + DenseDoubleMatrix1D.this.elements[idx] * elementsOther[idxOther] + DenseDoubleMatrix1D.this.elements[idx += DenseDoubleMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseDoubleMatrix1D.this.elements[idx += DenseDoubleMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Double)futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum += results[j].doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int min = tail - from;
            int k = min / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elementsOther[n2] + this.elements[n3] * elementsOther[n4] + this.elements[zeroThis] * elementsOther[zeroOther] + this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
            k = min % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    public double zSum() {
        double sum = 0.0;
        final double[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Double[] results = new Double[nthreads];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        int idx = DenseDoubleMatrix1D.this.zero + firstIdx * DenseDoubleMatrix1D.this.stride;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            sum += elems[idx];
                            idx += DenseDoubleMatrix1D.this.stride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Double)futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum += results[j].doubleValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            for (int k = 0; k < this.size; ++k) {
                sum += elems[idx];
                idx += this.stride;
            }
        }
        return sum;
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int index = this.zero;
        double[] elems = this.elements;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (elems[index] != 0.0) {
                ++cardinality;
            }
            index += this.stride;
        }
        return cardinality;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D otherMatrix = (SelectedDenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D otherMatrix = (DenseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseDoubleMatrix1D(this.elements, offsets);
    }
}

