/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

public class SparseRCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDoubleMatrix1D[] elements;

    public SparseRCMDoubleMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseDoubleMatrix1D[rows];
        for (int i = 0; i < rows; ++i) {
            this.elements[i] = new SparseDoubleMatrix1D(columns);
        }
    }

    public SparseDoubleMatrix1D[] elements() {
        return this.elements;
    }

    public double getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    public void setQuick(int row, int column, double value) {
        this.elements[row].setQuick(column, value);
    }

    public void trimToSize() {
        for (int r = 0; r < this.rows; ++r) {
            this.elements[r].trimToSize();
        }
    }

    public SparseDoubleMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseRCMDoubleMatrix2D(rows, columns);
    }
}

