/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.Float27Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DProcedure;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FloatMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected FloatMatrix3D() {
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FloatMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(FloatMatrix3D.this.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, final FloatProcedure cond) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float elem = FloatMatrix3D.this.getQuick(firstSlice, 0, 0);
                        float a = 0.0f;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FloatMatrix3D.this.columns; ++c) {
                                    elem = FloatMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                }
                            }
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            float elem = this.getQuick(0, 0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                    }
                }
            }
        }
        return a;
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            return Float.NaN;
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix3D.this.getQuick(sliceElements[firstIdx], rowElements[firstIdx], columnElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            float elem = FloatMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(sliceElements[0], rowElements[0], columnElements[0]));
            for (int i = 1; i < size; ++i) {
                float elem = this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public float aggregate(final FloatMatrix3D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FloatMatrix3D.this.columns; ++c) {
                                    a = aggr.apply(a, f.apply(FloatMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                }
                                d = 0;
                            }
                        }
                        return Float.valueOf(a);
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                    }
                    d = 0;
                }
            }
        }
        return a;
    }

    public FloatMatrix3D assign(final FloatFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, function.apply(FloatMatrix3D.this.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure cond, final FloatFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    float elem = FloatMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    FloatMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, f.apply(elem));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatProcedure cond, final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    float elem = FloatMatrix3D.this.getQuick(s, r, c);
                                    if (!cond.apply(elem)) continue;
                                    FloatMatrix3D.this.setQuick(s, r, c, value);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        float elem = this.getQuick(s, r, c);
                        if (!cond.apply(elem)) continue;
                        this.setQuick(s, r, c, value);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, value);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, value);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[] values) {
        if (values.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstSlice * FloatMatrix3D.this.rows * FloatMatrix3D.this.columns;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, values[idx++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, values[idx++]);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final float[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            float[][] currentSlice = values[s];
                            if (currentSlice.length != FloatMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + FloatMatrix3D.this.rows());
                            }
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                float[] currentRow = currentSlice[r];
                                if (currentRow.length != FloatMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + FloatMatrix3D.this.columns());
                                }
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, currentRow[c]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                float[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                for (int r = 0; r < this.rows; ++r) {
                    float[] currentRow = currentSlice[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, currentRow[c]);
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(FloatMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final FloatMatrix3D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, source.getQuick(s, r, c));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, source.getQuick(s, r, c));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatMatrix3D y, final FloatFloatFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    FloatMatrix3D.this.setQuick(s, r, c, function.apply(FloatMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                    }
                }
            }
        }
        return this;
    }

    public FloatMatrix3D assign(final FloatMatrix3D y, final FloatFloatFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            FloatMatrix3D.this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(FloatMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    if (FloatMatrix3D.this.getQuick(s, r, c) == 0.0f) continue;
                                    ++cardinality;
                                }
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        if (this.getQuick(s, r, c) == 0.0f) continue;
                        ++cardinality;
                    }
                }
            }
        }
        return cardinality;
    }

    public FloatMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(float value) {
        return FloatProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatMatrix3D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix3D)obj);
    }

    public float get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    public float[] getMaxLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        float maxValue = FloatMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FloatMatrix3D.this.columns; ++c) {
                                    float elem = FloatMatrix3D.this.getQuick(s, r, c);
                                    if (!(maxValue < elem)) continue;
                                    maxValue = elem;
                                    sliceLocation = s;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                d = 0;
                            }
                        }
                        return new float[]{maxValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                maxValue = results[0][0];
                sliceLocation = (int)results[0][1];
                rowLocation = (int)results[0][2];
                columnLocation = (int)results[0][3];
                for (j = 1; j < nthreads; ++j) {
                    if (!(maxValue < results[j][0])) continue;
                    maxValue = results[j][0];
                    sliceLocation = (int)results[j][1];
                    rowLocation = (int)results[j][2];
                    columnLocation = (int)results[j][3];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0, 0);
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        float elem = this.getQuick(s, r, c);
                        if (!(maxValue < elem)) continue;
                        maxValue = elem;
                        sliceLocation = s;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    d = 0;
                }
            }
        }
        return new float[]{maxValue, sliceLocation, rowLocation, columnLocation};
    }

    public float[] getMinLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        float minValue = FloatMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                for (int c = d; c < FloatMatrix3D.this.columns; ++c) {
                                    float elem = FloatMatrix3D.this.getQuick(s, r, c);
                                    if (!(minValue > elem)) continue;
                                    minValue = elem;
                                    sliceLocation = s;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                d = 0;
                            }
                        }
                        return new float[]{minValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (float[])futures[j].get();
                }
                minValue = results[0][0];
                sliceLocation = (int)results[0][1];
                rowLocation = (int)results[0][2];
                columnLocation = (int)results[0][3];
                for (j = 1; j < nthreads; ++j) {
                    if (!(minValue > results[j][0])) continue;
                    minValue = results[j][0];
                    sliceLocation = (int)results[j][1];
                    rowLocation = (int)results[j][2];
                    columnLocation = (int)results[j][3];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0, 0);
            int d = 1;
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = d; c < this.columns; ++c) {
                        float elem = this.getQuick(s, r, c);
                        if (!(minValue > elem)) continue;
                        minValue = elem;
                        sliceLocation = s;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    d = 0;
                }
            }
        }
        return new float[]{minValue, sliceLocation, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float value = this.getQuick(s, r, c);
                    if (!(value < 0.0f)) continue;
                    sliceList.add(s);
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
            }
        }
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float value = this.getQuick(s, r, c);
                    if (value == 0.0f) continue;
                    sliceList.add(s);
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int s = 0; s < this.slices; ++s) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    float value = this.getQuick(s, r, c);
                    if (!(value > 0.0f)) continue;
                    sliceList.add(s);
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
            }
        }
    }

    public abstract float getQuick(int var1, int var2, int var3);

    public FloatMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract FloatMatrix3D like(int var1, int var2, int var3);

    public abstract FloatMatrix2D like2D(int var1, int var2);

    public void normalize() {
        float min = this.getMinLocation()[0];
        if (min < 0.0f) {
            this.assign(FloatFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign(1.0f / (float)this.size());
        } else {
            float sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0f / sumScaleFactor;
            this.assign(FloatFunctions.mult(sumScaleFactor));
        }
    }

    public void set(int slice, int row, int column, float value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, float var4);

    public float[][][] toArray() {
        final float[][][] values = new float[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            float[][] currentSlice = values[s];
                            for (int r = 0; r < FloatMatrix3D.this.rows; ++r) {
                                float[] currentRow = currentSlice[r];
                                for (int c = 0; c < FloatMatrix3D.this.columns; ++c) {
                                    currentRow[c] = FloatMatrix3D.this.getQuick(s, r, c);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                float[][] currentSlice = values[s];
                for (int r = 0; r < this.rows; ++r) {
                    float[] currentRow = currentSlice[r];
                    for (int c = 0; c < this.columns; ++c) {
                        currentRow[c] = this.getQuick(s, r, c);
                    }
                }
            }
        }
        return values;
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public abstract FloatMatrix1D vectorize();

    public FloatMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FloatMatrix3D viewColumnFlip() {
        return (FloatMatrix3D)this.view().vColumnFlip();
    }

    public FloatMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (FloatMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public FloatMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (FloatMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public FloatMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FloatMatrix3D viewRowFlip() {
        return (FloatMatrix3D)this.view().vRowFlip();
    }

    public FloatMatrix3D viewSelection(FloatMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!condition.apply(this.viewSlice(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    public FloatMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            for (i2 = 0; i2 < this.slices; ++i2) {
                sliceIndexes[i2] = i2;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            for (i2 = 0; i2 < this.rows; ++i2) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            for (i2 = 0; i2 < this.columns; ++i2) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < sliceIndexes.length; ++i) {
            sliceOffsets[i] = this._sliceOffset(this._sliceRank(sliceIndexes[i]));
        }
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public FloatMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FloatMatrix3D viewSliceFlip() {
        return (FloatMatrix3D)this.view().vSliceFlip();
    }

    public FloatMatrix3D viewSorted(int row, int column) {
        return FloatSorting.mergeSort.sort(this, row, column);
    }

    public FloatMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (FloatMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    public void zAssign27Neighbors(FloatMatrix3D B, Float27Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        for (int k = 1; k < this.slices - 1; ++k) {
            for (int i = 1; i < r; ++i) {
                float a000 = this.getQuick(k - 1, i - 1, 0);
                float a001 = this.getQuick(k - 1, i - 1, 1);
                float a010 = this.getQuick(k - 1, i, 0);
                float a011 = this.getQuick(k - 1, i, 1);
                float a020 = this.getQuick(k - 1, i + 1, 0);
                float a021 = this.getQuick(k - 1, i + 1, 1);
                float a100 = this.getQuick(k - 1, i - 1, 0);
                float a101 = this.getQuick(k, i - 1, 1);
                float a110 = this.getQuick(k, i, 0);
                float a111 = this.getQuick(k, i, 1);
                float a120 = this.getQuick(k, i + 1, 0);
                float a121 = this.getQuick(k, i + 1, 1);
                float a200 = this.getQuick(k + 1, i - 1, 0);
                float a201 = this.getQuick(k + 1, i - 1, 1);
                float a210 = this.getQuick(k + 1, i, 0);
                float a211 = this.getQuick(k + 1, i, 1);
                float a220 = this.getQuick(k + 1, i + 1, 0);
                float a221 = this.getQuick(k + 1, i + 1, 1);
                for (int j = 1; j < c; ++j) {
                    float a002 = this.getQuick(k - 1, i - 1, j + 1);
                    float a012 = this.getQuick(k - 1, i, j + 1);
                    float a022 = this.getQuick(k - 1, i + 1, j + 1);
                    float a102 = this.getQuick(k, i - 1, j + 1);
                    float a112 = this.getQuick(k, i, j + 1);
                    float a122 = this.getQuick(k, i + 1, j + 1);
                    float a202 = this.getQuick(k + 1, i - 1, j + 1);
                    float a212 = this.getQuick(k + 1, i, j + 1);
                    float a222 = this.getQuick(k + 1, i + 1, j + 1);
                    B.setQuick(k, i, j, function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222));
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                }
            }
        }
    }

    public float zSum() {
        if (this.size() == 0L) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }

    protected FloatMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FloatMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix3D other) {
        return false;
    }

    protected abstract FloatMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected FloatMatrix3D view() {
        return (FloatMatrix3D)this.clone();
    }

    protected abstract FloatMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);
}

