/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class LongFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory2D dense = new LongFactory2D();
    public static final LongFactory2D sparse = new LongFactory2D();
    public static final LongFactory2D rowCompressed = new LongFactory2D();

    protected LongFactory2D() {
    }

    public LongMatrix2D appendColumns(LongMatrix2D A, LongMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        LongMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public LongMatrix2D appendColumn(LongMatrix2D A, LongMatrix1D b) {
        if (b.size() > (long)A.rows()) {
            b = b.viewPart(0, A.rows());
        } else if (b.size() < (long)A.rows()) {
            A = A.viewPart(0, 0, (int)b.size(), A.columns());
        }
        int ac = A.columns();
        int bc = 1;
        int r = A.rows();
        LongMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewColumn(ac).assign(b);
        return matrix;
    }

    public LongMatrix2D appendRows(LongMatrix2D A, LongMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        LongMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public LongMatrix2D appendRow(LongMatrix2D A, LongMatrix1D b) {
        if (b.size() > (long)A.columns()) {
            b = b.viewPart(0, A.columns());
        } else if (b.size() < (long)A.columns()) {
            A = A.viewPart(0, 0, A.rows(), (int)b.size());
        }
        int ar = A.rows();
        int br = 1;
        int c = A.columns();
        LongMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewRow(ar).assign(b);
        return matrix;
    }

    public LongMatrix2D ascending(int rows, int columns) {
        LongFunctions F = LongFunctions.longFunctions;
        return this.descending(rows, columns).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(columns * rows)));
    }

    protected static void checkRectangularShape(int[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(LongMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public LongMatrix2D reshape(LongMatrix1D a, int rows, int columns) {
        if (a.size() != (long)(rows * columns)) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        LongMatrix2D A = this == sparse ? new SparseLongMatrix2D(rows, columns) : new DenseLongMatrix2D(rows, columns);
        for (int c = 0; c < columns; ++c) {
            A.viewColumn(c).assign(a.viewPart(c * rows, rows));
        }
        return A;
    }

    public LongMatrix2D compose(LongMatrix2D[][] parts) {
        int row;
        LongFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        LongMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                LongMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                LongMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        LongMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                LongMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
        return matrix;
    }

    public LongMatrix2D composeDiagonal(LongMatrix2D A, LongMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        LongMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public LongMatrix2D composeDiagonal(LongMatrix2D A, LongMatrix2D B, LongMatrix2D C) {
        LongMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public LongMatrix2D composeBidiagonal(LongMatrix2D A, LongMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        LongMatrix2D sum = this.make(ar + br - 1, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar - 1, ac, br, bc).assign(B);
        return sum;
    }

    public void decompose(LongMatrix2D[][] parts, LongMatrix2D matrix) {
        int row;
        LongFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                LongMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                LongMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                LongMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        LongMatrix2D[][] parts1 = new LongMatrix2D[][]{{null, this.make(2, 2, 1L), null}, {this.make(4, 4, 2L), null, this.make(4, 3, 3L)}, {null, this.make(2, 2, 4L), null}};
        System.out.println("\n" + this.compose(parts1));
        LongMatrix2D[][] parts3 = new LongMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(parts3));
        LongMatrix2D A = this.ascending(2, 2);
        LongMatrix2D B = this.descending(2, 2);
        Object _ = null;
        LongMatrix2D[][] parts4 = new LongMatrix2D[][]{{A, _, A, _}, {_, A, _, B}};
        System.out.println("\n" + this.compose(parts4));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        LongMatrix2D A = this.make(2, 2, 1L);
        LongMatrix2D B = this.make(4, 4, 2L);
        LongMatrix2D C = this.make(4, 3, 3L);
        LongMatrix2D D = this.make(2, 2, 4L);
        LongMatrix2D[][] parts1 = new LongMatrix2D[][]{{_, A, _}, {B, _, C}, {_, D, _}};
        LongMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A.assign(9L);
        B.assign(9L);
        C.assign(9L);
        D.assign(9L);
        this.decompose(parts1, matrix);
        System.out.println(A);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public LongMatrix2D descending(int rows, int columns) {
        LongMatrix2D matrix = this.make(rows, columns);
        int v = 0;
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                matrix.setQuick(row, column, v++);
            }
        }
        return matrix;
    }

    public LongMatrix2D diagonal(LongMatrix1D vector) {
        int size = (int)vector.size();
        LongMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public LongMatrix2D diagonal(int[] vector) {
        int size = vector.length;
        LongMatrix2D diag = this.make(size, size);
        for (int i = 0; i < size; ++i) {
            diag.setQuick(i, i, vector[i]);
        }
        return diag;
    }

    public LongMatrix1D diagonal(LongMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        LongMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public LongMatrix2D identity(int rowsAndColumns) {
        LongMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, 1L);
        }
        return matrix;
    }

    public LongMatrix2D make(long[][] values) {
        if (this == sparse) {
            return new SparseLongMatrix2D(values);
        }
        return new DenseLongMatrix2D(values);
    }

    public LongMatrix2D make(int[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        LongMatrix2D matrix = this.make(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                matrix.setQuick(row, column, values[row + column * rows]);
            }
        }
        return matrix;
    }

    public LongMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseLongMatrix2D(rows, columns);
        }
        if (this == rowCompressed) {
            return new SparseRCLongMatrix2D(rows, columns);
        }
        return new DenseLongMatrix2D(rows, columns);
    }

    public LongMatrix2D make(int rows, int columns, long initialValue) {
        if (initialValue == 0L) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected LongMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public LongMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(LongFunctions.random());
    }

    public LongMatrix2D repeat(LongMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        LongMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }

    public LongMatrix2D sample(int rows, int columns, int value, int nonZeroFraction) {
        LongMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public LongMatrix2D sample(LongMatrix2D matrix, int value, int nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        double epsilon = 1.0E-9;
        if ((double)nonZeroFraction < 0.0 - epsilon || (double)nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0) {
            nonZeroFraction = 0;
        }
        if (nonZeroFraction > 1) {
            nonZeroFraction = 1;
        }
        matrix.assign(0L);
        int size = rows * columns;
        int n = Math.round(size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            int row = i / columns;
            int column = i % columns;
            matrix.set(row, column, value);
        }
        return matrix;
    }
}

