/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCMObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseRCMObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseRCObjectMatrix2D;

public class SparseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseObjectMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(rows, columns);
        this.elements = new OpenLongObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix2D(int rows, int columns, AbstractLongObjectMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    public SparseCCObjectMatrix2D getColumnCompressed(boolean sortRowIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        Object[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseCCObjectMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, sortRowIndexes);
    }

    public SparseCCMObjectMatrix2D getColumnCompressedModified() {
        SparseCCMObjectMatrix2D A = new SparseCCMObjectMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        Object[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    public SparseRCObjectMatrix2D getRowCompressed(boolean sortColumnIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        Object[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        for (int k = 0; k < nnz; ++k) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
        }
        return new SparseRCObjectMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, sortColumnIndexes);
    }

    public SparseRCMObjectMatrix2D getRowCompressedModified() {
        SparseRCMObjectMatrix2D A = new SparseRCMObjectMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        Object[] values = this.elements.values().elements();
        for (int i = 0; i < nnz; ++i) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
        }
        return A;
    }

    public synchronized Object getQuick(int row, int column) {
        return this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D otherMatrix = (SelectedSparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D otherMatrix = (SparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    protected ObjectMatrix1D like1D(int size, int offset, int stride) {
        return new SparseObjectMatrix1D(size, this.elements, offset, stride);
    }

    public synchronized void setQuick(int row, int column, Object value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == null) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D v = new SparseObjectMatrix1D((int)this.size());
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                Object elem = this.getQuick(r, c);
                v.setQuick(idx++, elem);
            }
        }
        return v;
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

